/*
Navicat MySQL Data Transfer

Source Server         : 111111
Source Server Version : 50554
Source Host           : localhost:3307
Source Database       : gzz_test

Target Server Type    : MYSQL
Target Server Version : 50554
File Encoding         : 65001

Date: 2022-01-25 11:01:15
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for tb_analysemed
-- ----------------------------
DROP TABLE IF EXISTS `tb_analysemed`;
CREATE TABLE `tb_analysemed` (
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `InstrumentGuid` char(36) NOT NULL,
  `ColumnParam` varchar(255) CHARACTER SET gbk NOT NULL COMMENT '色谱柱参数',
  `MobilePhase` varchar(255) CHARACTER SET gbk NOT NULL COMMENT '流动相',
  `bDel` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`Guid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_analysemed
-- ----------------------------

-- ----------------------------
-- Table structure for tb_calibrate
-- ----------------------------
DROP TABLE IF EXISTS `tb_calibrate`;
CREATE TABLE `tb_calibrate` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `BCalculate` int(11) NOT NULL DEFAULT '0' COMMENT '是否运算',
  `CreateTime` datetime NOT NULL,
  `BChanged` int(11) NOT NULL,
  `ChromGuid` char(36) NOT NULL,
  PRIMARY KEY (`ID`,`Guid`)
) ENGINE=MyISAM AUTO_INCREMENT=83 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_calibrate
-- ----------------------------

-- ----------------------------
-- Table structure for tb_calibratechrom
-- ----------------------------
DROP TABLE IF EXISTS `tb_calibratechrom`;
CREATE TABLE `tb_calibratechrom` (
  `CalibrateGuid` char(36) NOT NULL,
  `ChromGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `SampleName` varchar(255) CHARACTER SET gbk NOT NULL,
  `SampleType` int(11) NOT NULL COMMENT '样品类型',
  `CalibrateLevel` int(11) NOT NULL COMMENT '校准等级',
  `HalfPeakWidth` double DEFAULT NULL,
  `Slope` double DEFAULT NULL,
  `Drift` double DEFAULT NULL,
  `TDBL` double DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_calibratechrom
-- ----------------------------

-- ----------------------------
-- Table structure for tb_calibratechrompeak
-- ----------------------------
DROP TABLE IF EXISTS `tb_calibratechrompeak`;
CREATE TABLE `tb_calibratechrompeak` (
  `CalibrateGuid` char(36) NOT NULL,
  `ChromGuid` char(36) NOT NULL,
  `ChromRetainTime` double NOT NULL,
  `RetainTime` double NOT NULL,
  `Name` varchar(10) CHARACTER SET gbk NOT NULL COMMENT '元素名称',
  `Type` int(11) NOT NULL COMMENT '	ST_Unknow,\r\n	ST_Std,',
  `Level` int(11) NOT NULL,
  `Area` double NOT NULL,
  `Height` double NOT NULL,
  `X` double NOT NULL,
  `Y` double NOT NULL,
  `XUnit` varchar(255) NOT NULL,
  `YUnit` varchar(255) NOT NULL COMMENT '校准等级',
  `ResponseFactor` double NOT NULL COMMENT '响应因子',
  `CorrectFactor` double NOT NULL COMMENT '校正因子',
  `bCalc` int(11) NOT NULL DEFAULT '0' COMMENT '是否参与定量计算',
  `ResponseBase` int(11) NOT NULL,
  `TargetType` int(11) NOT NULL,
  `ISTDVol` double NOT NULL,
  `ForceName` varchar(255) CHARACTER SET gbk NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_calibratechrompeak
-- ----------------------------

-- ----------------------------
-- Table structure for tb_calibratechrompeakunknow
-- ----------------------------
DROP TABLE IF EXISTS `tb_calibratechrompeakunknow`;
CREATE TABLE `tb_calibratechrompeakunknow` (
  `CalibrateGuid` char(36) NOT NULL,
  `ChromGuid` char(36) NOT NULL,
  `ChromRetainTime` double NOT NULL,
  `RetainTime` double NOT NULL,
  `Name` varchar(10) CHARACTER SET gbk NOT NULL COMMENT '元素名称',
  `Type` int(11) NOT NULL COMMENT '	ST_Unknow,\r\n	ST_Std,',
  `Level` int(11) NOT NULL,
  `Area` double NOT NULL,
  `Height` double NOT NULL,
  `X` double NOT NULL,
  `Y` double NOT NULL,
  `XUnit` varchar(255) CHARACTER SET gbk NOT NULL,
  `YUnit` varchar(255) CHARACTER SET gbk NOT NULL,
  `ResponseFactor` double NOT NULL COMMENT '响应因子',
  `CorrectFactor` double NOT NULL COMMENT '校正因子',
  `bCalc` int(11) NOT NULL DEFAULT '0' COMMENT '是否参与定量计算',
  `ResponseBase` int(11) NOT NULL,
  `TargetType` int(11) NOT NULL,
  `ISTDVol` double NOT NULL,
  `ForceName` varchar(255) CHARACTER SET gbk NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_calibratechrompeakunknow
-- ----------------------------

-- ----------------------------
-- Table structure for tb_calibratechromunknow
-- ----------------------------
DROP TABLE IF EXISTS `tb_calibratechromunknow`;
CREATE TABLE `tb_calibratechromunknow` (
  `CalibrateGuid` char(36) NOT NULL,
  `ChromGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `SampleName` varchar(255) CHARACTER SET gbk NOT NULL,
  `SampleType` int(11) NOT NULL COMMENT '样品类型',
  `CalibrateLevel` int(11) NOT NULL COMMENT '校准等级',
  `HalfPeakWidth` double DEFAULT NULL,
  `Slope` double DEFAULT NULL,
  `Drift` double DEFAULT NULL,
  `TDBL` double DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_calibratechromunknow
-- ----------------------------

-- ----------------------------
-- Table structure for tb_calibratecompoundinfo
-- ----------------------------
DROP TABLE IF EXISTS `tb_calibratecompoundinfo`;
CREATE TABLE `tb_calibratecompoundinfo` (
  `CalibrateGuid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `RetainTime` double NOT NULL COMMENT '保留时间',
  `Area` double NOT NULL,
  `Height` double NOT NULL,
  `Concents` varchar(300) NOT NULL,
  `ISTDGroupID` int(11) NOT NULL DEFAULT '1',
  `k` double DEFAULT NULL,
  `b` double DEFAULT NULL,
  `r` double DEFAULT NULL,
  `TargetType` int(11) NOT NULL,
  `k2` double DEFAULT NULL,
  `k3` double DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_calibratecompoundinfo
-- ----------------------------

-- ----------------------------
-- Table structure for tb_calibratecompoundinfoquantify
-- ----------------------------
DROP TABLE IF EXISTS `tb_calibratecompoundinfoquantify`;
CREATE TABLE `tb_calibratecompoundinfoquantify` (
  `CalibrateGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `QualitativeType` int(11) NOT NULL COMMENT '	QLT_TimeWindow,\r\n	QLT_TimeBand',
  `WindowValue` double NOT NULL,
  `BandValue` double NOT NULL,
  `QuantifyType` int(11) NOT NULL COMMENT '定量方法类型：QMT_Normalization,//归一\r\nQMT_ESTD,	// 外标法\r\nQMT_ISTD,	// 内标法\r\nQMT_ASTD,	// 标准加入法',
  `ResponseBase` int(11) NOT NULL COMMENT '响应基础：RB_Area,	 RB_Height',
  `CarlibrateCount` int(11) NOT NULL COMMENT '校准点数',
  `CurveFitType` int(11) NOT NULL COMMENT '曲线拟合类型：0 线性',
  `Origin` int(11) NOT NULL COMMENT '原点：OP_Without, \r\nOP_Calc,\r\nOP_Pass',
  `WeightMethod` int(11) NOT NULL COMMENT '权重方法：0，无',
  `Unit` varchar(10) CHARACTER SET gbk NOT NULL,
  `BEraseEmpty` int(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_calibratecompoundinfoquantify
-- ----------------------------

-- ----------------------------
-- Table structure for tb_calibratelinerrepeat
-- ----------------------------
DROP TABLE IF EXISTS `tb_calibratelinerrepeat`;
CREATE TABLE `tb_calibratelinerrepeat` (
  `CalibrateGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `r` double NOT NULL,
  `k` double NOT NULL,
  `b` double NOT NULL,
  `AvgRetainTime` double NOT NULL,
  `RSDRetainTime` double NOT NULL,
  `AvgArea` double NOT NULL,
  `RSDArea` double NOT NULL,
  `AvgHeight` double NOT NULL,
  `RSDHeight` double NOT NULL,
  `RepeatGuids` varchar(1000) NOT NULL,
  `BUseRepeat` int(11) NOT NULL DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_calibratelinerrepeat
-- ----------------------------

-- ----------------------------
-- Table structure for tb_calibratequantifymed
-- ----------------------------
DROP TABLE IF EXISTS `tb_calibratequantifymed`;
CREATE TABLE `tb_calibratequantifymed` (
  `CalibrateGuid` char(36) NOT NULL,
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `ChromGuid` char(36) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_calibratequantifymed
-- ----------------------------

-- ----------------------------
-- Table structure for tb_calibratequantifyparam
-- ----------------------------
DROP TABLE IF EXISTS `tb_calibratequantifyparam`;
CREATE TABLE `tb_calibratequantifyparam` (
  `CalibrateGuid` char(36) NOT NULL,
  `QuantifyGuid` char(36) NOT NULL,
  `QualitativeType` int(11) NOT NULL COMMENT '	QLT_TimeWindow,\r\n	QLT_TimeBand',
  `WindowValue` double NOT NULL,
  `BandValue` double NOT NULL,
  `QuantifyType` int(11) NOT NULL COMMENT '定量方法类型：QMT_Normalization,//归一\r\nQMT_ESTD,	// 外标法\r\nQMT_ISTD,	// 内标法\r\nQMT_ASTD,	// 标准加入法',
  `ResponseBase` int(11) NOT NULL COMMENT '响应基础：RB_Area,	 RB_Height',
  `CarlibrateCount` int(11) NOT NULL COMMENT '校准点数',
  `CurveFitType` int(11) NOT NULL COMMENT '曲线拟合类型：0 线性',
  `Origin` int(11) NOT NULL COMMENT '原点：OP_Without, \r\nOP_Calc,\r\nOP_Pass',
  `WeightMethod` int(11) NOT NULL COMMENT '权重方法：0，无',
  `Unit` varchar(10) CHARACTER SET gbk NOT NULL,
  PRIMARY KEY (`CalibrateGuid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_calibratequantifyparam
-- ----------------------------

-- ----------------------------
-- Table structure for tb_calibratequantifypeak
-- ----------------------------
DROP TABLE IF EXISTS `tb_calibratequantifypeak`;
CREATE TABLE `tb_calibratequantifypeak` (
  `CalibrateGuid` char(36) NOT NULL,
  `QuantifyGuid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `RetainTime` double NOT NULL COMMENT '保留时间',
  `Area` double NOT NULL,
  `Height` double NOT NULL,
  `PeakGuid` char(36) NOT NULL,
  `Concents` varchar(300) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_calibratequantifypeak
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chromatogram
-- ----------------------------
DROP TABLE IF EXISTS `tb_chromatogram`;
CREATE TABLE `tb_chromatogram` (
  `Guid` char(36) NOT NULL,
  `TaskGuid` char(36) NOT NULL,
  `SeqGuid` char(36) NOT NULL,
  `ProjectGuid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `SampleName` varchar(255) CHARACTER SET gbk NOT NULL,
  `SampleType` int(11) NOT NULL COMMENT '0, ST_Unknow,;1, ST_Std,',
  `CreateTime` datetime NOT NULL,
  `EndTime` datetime NOT NULL,
  `AnalyseGuid` char(36) NOT NULL,
  `AnalyseName` varchar(255) CHARACTER SET gbk NOT NULL,
  `State` int(11) NOT NULL DEFAULT '0' COMMENT '状态：0，running；1， finished',
  `LoopCount` int(11) NOT NULL,
  `InjectVol` int(11) NOT NULL,
  `InjectTime` int(11) NOT NULL,
  `VialNum` int(11) NOT NULL,
  `CurIndex` int(11) NOT NULL DEFAULT '0',
  `FileName` varchar(255) CHARACTER SET gbk NOT NULL,
  `CalibrateGuid` char(36) NOT NULL DEFAULT '',
  `YUnit` int(11) NOT NULL DEFAULT '18' COMMENT '	UL_One = 1,	// 1\r\n	UL_m,	// 毫\r\n	UL_u,	// 微\r\n	UL_n,	// 纳\r\n	UL_K,	// 千\r\n	UL_M,	// 兆\r\n\r\n	UD_SCM	= 16,		// 西门子/cm\r\n	UD_V	= 32,		// 电压\r\n};',
  `YUnitStr` varchar(255) CHARACTER SET gbk NOT NULL,
  `LastModifyTime` datetime NOT NULL,
  `BIntegral` int(11) NOT NULL DEFAULT '0' COMMENT '是否积分',
  `SampleVol` double NOT NULL,
  `DilFactor` double NOT NULL,
  `ISTDVol` double NOT NULL COMMENT '内标量',
  `PrintTemplateGuid` char(36) NOT NULL,
  `SSTGuid` char(36) DEFAULT NULL,
  `showheaders` varchar(50) NOT NULL,
  `HZ` int(11) NOT NULL DEFAULT '5',
  `bDel` int(1) NOT NULL DEFAULT '0',
  `MateVol` double NOT NULL DEFAULT '1',
  `SampleID` varchar(255) CHARACTER SET gbk NOT NULL,
  `CheckCode` char(36) NOT NULL,
  PRIMARY KEY (`Guid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chromatogram
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chromatogramext
-- ----------------------------
DROP TABLE IF EXISTS `tb_chromatogramext`;
CREATE TABLE `tb_chromatogramext` (
  `ChromGuid` char(36) NOT NULL,
  `RangeMax` double DEFAULT NULL,
  `RangeMin` double DEFAULT NULL,
  `CalcStd` int(1) NOT NULL DEFAULT '0',
  `RangeMaxX` double DEFAULT NULL,
  `RangeMinX` double DEFAULT NULL,
  PRIMARY KEY (`ChromGuid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chromatogramext
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chromatogramext_copy
-- ----------------------------
DROP TABLE IF EXISTS `tb_chromatogramext_copy`;
CREATE TABLE `tb_chromatogramext_copy` (
  `ChromGuid` char(36) NOT NULL,
  `RangeMax` int(11) NOT NULL,
  `RangeMin` int(11) NOT NULL,
  PRIMARY KEY (`ChromGuid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chromatogramext_copy
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chromdatas
-- ----------------------------
DROP TABLE IF EXISTS `tb_chromdatas`;
CREATE TABLE `tb_chromdatas` (
  `ChromGuid` char(36) NOT NULL,
  `VarType` int(11) NOT NULL COMMENT '数据类型：1，整数；2，浮点数；3，字符串,4时间',
  `MType` int(11) NOT NULL COMMENT ' MT_Liquid = 0x10, \r\n MT_Supp  = 0x11, \r\n MT_Detector = 0x12, \r\n MT_Temp  = 0x13, \r\n MT_Eluent = 0x14,\r\n MT_Auxiliary= 0x15,\r\n MT_Pump  = 0x16,\r\n MT_AS  = 0x20, \r\n MT_Gas  = 0x30,',
  `VarName` varchar(255) CHARACTER SET gbk NOT NULL,
  `datas` longblob NOT NULL,
  `Size` int(11) NOT NULL,
  `SubVarName` varchar(10) NOT NULL COMMENT '一个模块可能产生多个值，比如：泵 （流速、压力）',
  KEY `idx_chromguid` (`ChromGuid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chromdatas
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chromdatasslopecurve
-- ----------------------------
DROP TABLE IF EXISTS `tb_chromdatasslopecurve`;
CREATE TABLE `tb_chromdatasslopecurve` (
  `ChromGuid` char(36) NOT NULL,
  `datasslope` longblob NOT NULL,
  `datascurve` longblob NOT NULL,
  `Size` int(11) NOT NULL,
  KEY `idx_chromguid` (`ChromGuid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chromdatasslopecurve
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chromintegral
-- ----------------------------
DROP TABLE IF EXISTS `tb_chromintegral`;
CREATE TABLE `tb_chromintegral` (
  `ChromGuid` char(36) NOT NULL,
  `Width` double DEFAULT NULL,
  `Slope` double DEFAULT NULL,
  `Drift` double DEFAULT NULL,
  `TDBL` double DEFAULT NULL,
  `MinHeight` double NOT NULL DEFAULT '0',
  `MinArea` double NOT NULL DEFAULT '0',
  `Start` double NOT NULL DEFAULT '-1',
  `End` double NOT NULL DEFAULT '-1',
  `UpCount` int(11) NOT NULL DEFAULT '8',
  `bNoNegative` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`ChromGuid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chromintegral
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chromintegralnew
-- ----------------------------
DROP TABLE IF EXISTS `tb_chromintegralnew`;
CREATE TABLE `tb_chromintegralnew` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ChromGuid` char(36) NOT NULL,
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `Width` double DEFAULT NULL,
  `Slope` double DEFAULT NULL,
  `Drift` double DEFAULT NULL,
  `TDBL` double DEFAULT NULL,
  `MinHeight` double NOT NULL,
  `MinArea` double NOT NULL,
  `baselinechromguid` char(36) NOT NULL,
  PRIMARY KEY (`ID`,`ChromGuid`)
) ENGINE=MyISAM AUTO_INCREMENT=276 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chromintegralnew
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chromintegralop
-- ----------------------------
DROP TABLE IF EXISTS `tb_chromintegralop`;
CREATE TABLE `tb_chromintegralop` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `IntegralGuid` char(36) NOT NULL,
  `Guid` char(36) NOT NULL,
  `Name` varchar(50) CHARACTER SET gbk NOT NULL,
  `OpType` int(11) NOT NULL COMMENT 'COP_Delete, //删除峰\r\n	COP_PeakSeparation, //峰谷分离\r\n	COP_VerticalSeparation, //垂直分离\r\n	COP_HorizontalForward, //水平向前\r\n	COP_HorizontalBack, //水平向后\r\n	COP_TangentForward, //前切线\r\n	COP_TangentBack, //后切线\r\n	COP_ConvertNegativePeak, //转换负峰\r\n	COP_CutNegativePeak, //剪切负峰\r\n	COP_DiscardNegativePeak, //舍弃负峰\r\n	//允许交差\r\n	//删除脉冲\r\n\r\n	COP_PeakStart, //峰起点\r\n	COP_PeakEnd, //峰终点\r\n	COP_PeakSeprationPos, //分界点\r\n	COP_AddPeak, //添加正峰\r\n	COP_AddNegativePeak, //添加负峰\r\n	COP_PeakName, //强制峰命名\r\n	COP_SolventPeak, //溶剂峰',
  `StartOpX` double DEFAULT NULL,
  `StartOpY` double DEFAULT NULL,
  `StartOpIndex` int(11) DEFAULT NULL,
  `EndOpX` double DEFAULT NULL,
  `EndOpY` double DEFAULT NULL,
  `EndOpIndex` int(11) DEFAULT NULL,
  `Value` double DEFAULT NULL,
  `ChromGuid` char(36) NOT NULL,
  `SortIndex` int(11) NOT NULL,
  PRIMARY KEY (`ID`,`Guid`),
  KEY `idx_chromguid` (`ChromGuid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=318 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chromintegralop
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chrommed
-- ----------------------------
DROP TABLE IF EXISTS `tb_chrommed`;
CREATE TABLE `tb_chrommed` (
  `AnalyseGuid` char(36) NOT NULL,
  `VarName` varchar(255) DEFAULT NULL,
  `value` varchar(5000) DEFAULT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Type` int(11) NOT NULL,
  `ModuleDeviceGuid` char(36) NOT NULL,
  `ChromGuid` char(36) NOT NULL,
  KEY `idx_chromguid` (`ChromGuid`,`AnalyseGuid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chrommed
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chrommedmain
-- ----------------------------
DROP TABLE IF EXISTS `tb_chrommedmain`;
CREATE TABLE `tb_chrommedmain` (
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `InstrumentGuid` char(36) NOT NULL,
  `ChromGuid` char(36) NOT NULL,
  `ColumnParam` varchar(255) CHARACTER SET gbk NOT NULL COMMENT '色谱柱参数',
  `MobilePhase` varchar(255) CHARACTER SET gbk NOT NULL COMMENT '流动相',
  KEY `idx_chromguid` (`ChromGuid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chrommedmain
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chrommeduserprog
-- ----------------------------
DROP TABLE IF EXISTS `tb_chrommeduserprog`;
CREATE TABLE `tb_chrommeduserprog` (
  `ChromGuid` char(36) NOT NULL,
  `AnalyseGuid` char(36) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Module` varchar(255) NOT NULL,
  `VarName` varchar(255) DEFAULT NULL,
  `Value` varchar(255) DEFAULT NULL,
  `Index` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chrommeduserprog
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chromop
-- ----------------------------
DROP TABLE IF EXISTS `tb_chromop`;
CREATE TABLE `tb_chromop` (
  `ChromGuid` char(36) NOT NULL,
  `Guid` char(36) NOT NULL,
  `Name` varchar(50) CHARACTER SET gbk NOT NULL,
  `OpType` int(11) NOT NULL COMMENT 'COP_Delete, //删除峰\r\n	COP_PeakSeparation, //峰谷分离\r\n	COP_VerticalSeparation, //垂直分离\r\n	COP_HorizontalForward, //水平向前\r\n	COP_HorizontalBack, //水平向后\r\n	COP_TangentForward, //前切线\r\n	COP_TangentBack, //后切线\r\n	COP_ConvertNegativePeak, //转换负峰\r\n	COP_CutNegativePeak, //剪切负峰\r\n	COP_DiscardNegativePeak, //舍弃负峰\r\n	//允许交差\r\n	//删除脉冲\r\n\r\n	COP_PeakStart, //峰起点\r\n	COP_PeakEnd, //峰终点\r\n	COP_PeakSeprationPos, //分界点\r\n	COP_AddPeak, //添加正峰\r\n	COP_AddNegativePeak, //添加负峰\r\n	COP_PeakName, //强制峰命名\r\n	COP_SolventPeak, //溶剂峰',
  `StartOpX` double NOT NULL,
  `StartOpY` double NOT NULL,
  `StartOpIndex` int(11) NOT NULL,
  `EndOpX` double NOT NULL,
  `EndOpY` double NOT NULL,
  `EndOpIndex` int(11) NOT NULL,
  `bValid` int(11) NOT NULL,
  `OpTime` varchar(50) NOT NULL,
  `DoFlag` int(11) NOT NULL DEFAULT '1' COMMENT '1, Do; 2, Redo; 0, Undo'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chromop
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chromopshape
-- ----------------------------
DROP TABLE IF EXISTS `tb_chromopshape`;
CREATE TABLE `tb_chromopshape` (
  `ChromOpGuid` char(36) NOT NULL,
  `ShapeGuid` char(36) NOT NULL,
  `ShapeType` int(11) NOT NULL COMMENT '		PS_None,\r\n		PS_Single,\r\n		PS_OverLap',
  `HorzType` int(11) NOT NULL DEFAULT '0' COMMENT 'enum HorzType\r\n{\r\n	OT_Null,\r\n	OT_HorzForward,\r\n	OT_HorzBackWard\r\n};',
  `OldORNew` int(11) NOT NULL COMMENT '0, old;1, new'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chromopshape
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chromopshapepeak
-- ----------------------------
DROP TABLE IF EXISTS `tb_chromopshapepeak`;
CREATE TABLE `tb_chromopshapepeak` (
  `ShapeGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `bNew` int(11) NOT NULL DEFAULT '0',
  `bDel` int(11) NOT NULL DEFAULT '0',
  `HorzType` int(11) NOT NULL COMMENT '	OT_Null,\r\n	OT_HorzForward,\r\n	OT_HorzBackWard',
  `RidingType` int(11) NOT NULL COMMENT 'RT_Null,\r\nRT_Child = 1,	//骑峰的子峰\r\nRT_ParentForward = 2,	//骑峰的母峰\r\nRT_ParentBackward = 4',
  `StartX` double NOT NULL,
  `StartY` double NOT NULL,
  `StartIndex` int(11) NOT NULL,
  `TopX` double NOT NULL,
  `TopY` double NOT NULL,
  `TopIndex` int(11) NOT NULL,
  `EndX` double NOT NULL,
  `EndY` double NOT NULL,
  `EndIndex` int(11) NOT NULL,
  `EndPType` int(11) NOT NULL COMMENT '区分谷点还是终点'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chromopshapepeak
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chromop_log
-- ----------------------------
DROP TABLE IF EXISTS `tb_chromop_log`;
CREATE TABLE `tb_chromop_log` (
  `ChromGuid` char(36) NOT NULL,
  `Guid` char(36) NOT NULL,
  `Name` varchar(50) CHARACTER SET gbk NOT NULL,
  `OpType` int(11) NOT NULL COMMENT 'COP_Delete, //删除峰\r\n	COP_PeakSeparation, //峰谷分离\r\n	COP_VerticalSeparation, //垂直分离\r\n	COP_HorizontalForward, //水平向前\r\n	COP_HorizontalBack, //水平向后\r\n	COP_TangentForward, //前切线\r\n	COP_TangentBack, //后切线\r\n	COP_ConvertNegativePeak, //转换负峰\r\n	COP_CutNegativePeak, //剪切负峰\r\n	COP_DiscardNegativePeak, //舍弃负峰\r\n	//允许交差\r\n	//删除脉冲\r\n\r\n	COP_PeakStart, //峰起点\r\n	COP_PeakEnd, //峰终点\r\n	COP_PeakSeprationPos, //分界点\r\n	COP_AddPeak, //添加正峰\r\n	COP_AddNegativePeak, //添加负峰\r\n	COP_PeakName, //强制峰命名\r\n	COP_SolventPeak, //溶剂峰',
  `StartOpX` double NOT NULL,
  `StartOpY` double NOT NULL,
  `StartOpIndex` int(11) NOT NULL,
  `EndOpX` double NOT NULL,
  `EndOpY` double NOT NULL,
  `EndOpIndex` int(11) NOT NULL,
  `bValid` int(11) NOT NULL,
  `OpTime` varchar(50) NOT NULL,
  `DoFlag` int(11) NOT NULL DEFAULT '1' COMMENT '1, Do; 2, Redo; 0, Undo'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chromop_log
-- ----------------------------

-- ----------------------------
-- Table structure for tb_chrompeakresult
-- ----------------------------
DROP TABLE IF EXISTS `tb_chrompeakresult`;
CREATE TABLE `tb_chrompeakresult` (
  `ChromGuid` char(36) NOT NULL,
  `CalibrateGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `Centent` double DEFAULT NULL,
  `CententuL` double DEFAULT NULL,
  `PeakType` int(11) NOT NULL,
  `Height` double NOT NULL,
  `Area` double NOT NULL,
  `ResponseBase` int(11) NOT NULL,
  `HalfWidth` double NOT NULL,
  `StartTime` int(11) NOT NULL,
  `StartValue` double NOT NULL,
  `EndTime` int(11) NOT NULL,
  `EndValue` double NOT NULL,
  `TopValue` double NOT NULL,
  `ResponseFactor` double DEFAULT NULL,
  `CorrectFactor` double DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_chrompeakresult
-- ----------------------------

-- ----------------------------
-- Table structure for tb_colautostart
-- ----------------------------
DROP TABLE IF EXISTS `tb_colautostart`;
CREATE TABLE `tb_colautostart` (
  `ColNo` char(36) NOT NULL,
  `Index` int(11) NOT NULL,
  `Module` varchar(255) NOT NULL,
  `SubDeviceType` int(11) NOT NULL,
  `Param` varchar(255) NOT NULL,
  `Value` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_colautostart
-- ----------------------------

-- ----------------------------
-- Table structure for tb_colcompound
-- ----------------------------
DROP TABLE IF EXISTS `tb_colcompound`;
CREATE TABLE `tb_colcompound` (
  `Type` int(11) NOT NULL DEFAULT '1' COMMENT '1, 阴 2，阳',
  `Name` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_colcompound
-- ----------------------------
INSERT INTO `tb_colcompound` VALUES ('1', 'F');
INSERT INTO `tb_colcompound` VALUES ('1', 'Cl ');
INSERT INTO `tb_colcompound` VALUES ('1', 'NO2 ');
INSERT INTO `tb_colcompound` VALUES ('1', 'Br ');
INSERT INTO `tb_colcompound` VALUES ('1', 'NO3 ');
INSERT INTO `tb_colcompound` VALUES ('1', 'BrO3 ');
INSERT INTO `tb_colcompound` VALUES ('1', 'SO4 ');
INSERT INTO `tb_colcompound` VALUES ('1', 'PO4 ');
INSERT INTO `tb_colcompound` VALUES ('1', 'ClO3 ');
INSERT INTO `tb_colcompound` VALUES ('1', 'ClO2 ');
INSERT INTO `tb_colcompound` VALUES ('1', 'I ');
INSERT INTO `tb_colcompound` VALUES ('1', 'SCN ');
INSERT INTO `tb_colcompound` VALUES ('1', 'S2O3 ');
INSERT INTO `tb_colcompound` VALUES ('1', 'SO3 ');
INSERT INTO `tb_colcompound` VALUES ('1', 'DCA ');
INSERT INTO `tb_colcompound` VALUES ('1', 'TCA ');
INSERT INTO `tb_colcompound` VALUES ('1', 'HCOOH ');
INSERT INTO `tb_colcompound` VALUES ('1', 'C2H4O2 ');
INSERT INTO `tb_colcompound` VALUES ('1', 'C2H2O4 ');
INSERT INTO `tb_colcompound` VALUES ('1', 'ClO4');
INSERT INTO `tb_colcompound` VALUES ('2', 'Li ');
INSERT INTO `tb_colcompound` VALUES ('2', 'Na ');
INSERT INTO `tb_colcompound` VALUES ('2', 'K ');
INSERT INTO `tb_colcompound` VALUES ('2', 'NH4 ');
INSERT INTO `tb_colcompound` VALUES ('2', 'Mg ');
INSERT INTO `tb_colcompound` VALUES ('2', 'Ca ');
INSERT INTO `tb_colcompound` VALUES ('2', 'MMA ');
INSERT INTO `tb_colcompound` VALUES ('2', 'DMA ');
INSERT INTO `tb_colcompound` VALUES ('2', 'TMA ');
INSERT INTO `tb_colcompound` VALUES ('2', 'ETA');
INSERT INTO `tb_colcompound` VALUES ('1', 'H2PO4');

-- ----------------------------
-- Table structure for tb_colcompound_copy
-- ----------------------------
DROP TABLE IF EXISTS `tb_colcompound_copy`;
CREATE TABLE `tb_colcompound_copy` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `Concentration` double NOT NULL,
  `InjectVol` int(11) NOT NULL,
  `ColumnName` varchar(255) CHARACTER SET gbk NOT NULL,
  `Speed` double NOT NULL,
  `Temp` double NOT NULL,
  `MobilePhase` varchar(255) CHARACTER SET gbk NOT NULL,
  `EluentConcentration` double NOT NULL,
  `Height` double NOT NULL,
  `HalfWidth` double NOT NULL,
  `RetentionTime` double NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_colcompound_copy
-- ----------------------------
INSERT INTO `tb_colcompound_copy` VALUES ('1', 'Li', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '3', '8.382644', '0.247083', '7.57');
INSERT INTO `tb_colcompound_copy` VALUES ('2', 'Li', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '5', '11.341095', '0.193455', '5.873333');
INSERT INTO `tb_colcompound_copy` VALUES ('3', 'Li', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '8', '12.431703', '0.168579', '4.86');
INSERT INTO `tb_colcompound_copy` VALUES ('4', 'Li', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '10', '10.555091', '0.163716', '4.523333');
INSERT INTO `tb_colcompound_copy` VALUES ('5', 'Na', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '3', '2.017537', '0.296704', '10.316667');
INSERT INTO `tb_colcompound_copy` VALUES ('6', 'Na', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '5', '2.746026', '0.220985', '7.516667');
INSERT INTO `tb_colcompound_copy` VALUES ('7', 'Na', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '8', '3.239108', '0.1854', '6.006667');
INSERT INTO `tb_colcompound_copy` VALUES ('8', 'Na', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '10', '2.451826', '0.178779', '5.573333');
INSERT INTO `tb_colcompound_copy` VALUES ('9', 'K', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '3', '0.370181', '0.598815', '20.226667');
INSERT INTO `tb_colcompound_copy` VALUES ('10', 'K', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '5', '0.621537', '0.38407', '13.69');
INSERT INTO `tb_colcompound_copy` VALUES ('11', 'K', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '8', '0.800275', '0.292879', '10.136667');
INSERT INTO `tb_colcompound_copy` VALUES ('12', 'K', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '10', '0.877145', '0.266549', '9.18');
INSERT INTO `tb_colcompound_copy` VALUES ('13', 'NH4', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '3', '1.313', '0.364272', '12.926667');
INSERT INTO `tb_colcompound_copy` VALUES ('14', 'NH4', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '5', '2.023462', '0.256789', '9.143333');
INSERT INTO `tb_colcompound_copy` VALUES ('15', 'NH4', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '8', '2.319079', '0.21735', '7.1');
INSERT INTO `tb_colcompound_copy` VALUES ('16', 'NH4', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '10', '2.287587', '0.204102', '6.52');
INSERT INTO `tb_colcompound_copy` VALUES ('17', 'Mg', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '3', '0.1742', '4.945659', '54.246667');
INSERT INTO `tb_colcompound_copy` VALUES ('18', 'Mg', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '5', '0.374432', '2.583637', '22.6');
INSERT INTO `tb_colcompound_copy` VALUES ('19', 'Mg', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '8', '0.53423', '1.737817', '11.696667');
INSERT INTO `tb_colcompound_copy` VALUES ('20', 'Mg', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '10', '0.48359', '1.529155', '9.37');
INSERT INTO `tb_colcompound_copy` VALUES ('21', 'Ca', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '3', '0.07487', '4.859778', '84.816667');
INSERT INTO `tb_colcompound_copy` VALUES ('22', 'Ca', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '5', '0.180723', '2.635819', '34.713333');
INSERT INTO `tb_colcompound_copy` VALUES ('23', 'Ca', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '8', '0.262254', '1.727662', '16.726667');
INSERT INTO `tb_colcompound_copy` VALUES ('24', 'Ca', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '10', '0.280828', '1.475864', '13.053333');
INSERT INTO `tb_colcompound_copy` VALUES ('25', 'MMA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '3', '0.519505', '0.509864', '18.05');
INSERT INTO `tb_colcompound_copy` VALUES ('26', 'MMA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '5', '0.878903', '0.345462', '12.38');
INSERT INTO `tb_colcompound_copy` VALUES ('27', 'MMA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '8', '1.139383', '0.264512', '9.183333');
INSERT INTO `tb_colcompound_copy` VALUES ('28', 'MMA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '10', '0.879851', '0.246019', '8.29');
INSERT INTO `tb_colcompound_copy` VALUES ('29', 'DMA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '3', '0.214037', '0.900647', '27.936667');
INSERT INTO `tb_colcompound_copy` VALUES ('30', 'DMA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '5', '0.371312', '0.588767', '18.57');
INSERT INTO `tb_colcompound_copy` VALUES ('31', 'DMA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '8', '0.506176', '0.432542', '13.236667');
INSERT INTO `tb_colcompound_copy` VALUES ('32', 'DMA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '10', '0.488441', '0.396304', '11.783333');
INSERT INTO `tb_colcompound_copy` VALUES ('33', 'TMA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '3', '0.049441', '2.055675', '47.48');
INSERT INTO `tb_colcompound_copy` VALUES ('34', 'TMA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '5', '0.079998', '1.262294', '30.756667');
INSERT INTO `tb_colcompound_copy` VALUES ('35', 'TMA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '8', '0.109799', '0.904743', '21.133333');
INSERT INTO `tb_colcompound_copy` VALUES ('36', 'TMA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '10', '0.100182', '0.811585', '18.68');
INSERT INTO `tb_colcompound_copy` VALUES ('37', 'ETA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '3', '0.32099', '0.5417', '16.256667');
INSERT INTO `tb_colcompound_copy` VALUES ('38', 'ETA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '5', '0.55512', '0.370582', '11.28');
INSERT INTO `tb_colcompound_copy` VALUES ('39', 'ETA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '8', '0.697004', '0.293126', '8.43');
INSERT INTO `tb_colcompound_copy` VALUES ('40', 'ETA', '1', '25', 'SH-CC-3L', '1', '35', 'MSA', '10', '0.612399', '0.274136', '7.66');

-- ----------------------------
-- Table structure for tb_colgradient
-- ----------------------------
DROP TABLE IF EXISTS `tb_colgradient`;
CREATE TABLE `tb_colgradient` (
  `ColNo` varchar(255) NOT NULL,
  `index` int(11) NOT NULL,
  `Time` double NOT NULL,
  `Conc` double NOT NULL,
  `Conc2` double NOT NULL,
  `Conc3` double NOT NULL,
  `Conc4` double NOT NULL,
  `Value` double NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_colgradient
-- ----------------------------

-- ----------------------------
-- Table structure for tb_columninfo
-- ----------------------------
DROP TABLE IF EXISTS `tb_columninfo`;
CREATE TABLE `tb_columninfo` (
  `No` varchar(255) NOT NULL,
  `Name` varchar(255) NOT NULL,
  `Guige` varchar(255) NOT NULL,
  `Speed` double NOT NULL,
  `Temp` double NOT NULL DEFAULT '35',
  `EluentMode` int(11) NOT NULL DEFAULT '0' COMMENT '0,等度；1，梯度',
  `MobilePhase` varchar(255) CHARACTER SET gbk NOT NULL,
  `Elec` int(11) NOT NULL,
  `Count` int(11) NOT NULL,
  `A` varchar(255) CHARACTER SET gbk NOT NULL,
  `B` varchar(255) CHARACTER SET gbk NOT NULL,
  `C` varchar(255) CHARACTER SET gbk NOT NULL,
  `D` varchar(255) CHARACTER SET gbk NOT NULL,
  `AC` double NOT NULL,
  `BC` double NOT NULL,
  `CC` double NOT NULL,
  `DC` double NOT NULL,
  PRIMARY KEY (`No`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_columninfo
-- ----------------------------
INSERT INTO `tb_columninfo` VALUES ('SH-AC-1', 'SH-AC-1', '250mm*4.6mm', '1.5', '30', '0', '3.6mM Na2CO3+4.5mM NaHCO3 ', '75', '0', 'Na2CO3', 'NaHCO3', '', '', '3.6', '4.5', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-11', 'SH-AC-11', '250mm*4.6mm', '1', '35', '0', '15.0mM NaOH', '75', '1', 'NaOH', '', '', '', '15', '0', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-12A', 'SH-AC-12A', '250mm*3.0mm', '0.5', '35', '0', '15.0mM NaOH', '40', '1', 'NaOH', '', '', '', '15', '0', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-12B', 'SH-AC-12B', '250mm*3.0mm', '0.4', '35', '0', '4.8mM Na2CO3+6.0mM NaHCO3', '40', '0', 'Na2CO3', 'NaHCO3', '', '', '4.8', '6', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-12C', 'SH-AC-12C', '150mm*3.0mm', '0.5', '35', '0', '4.8mM Na2CO3+6.0mM NaHCO3', '40', '0', 'Na2CO3', 'NaHCO3', '', '', '4.8', '6', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-14', 'SH-AC-14', '150mm*4.6mm', '1.5', '35', '0', '100mMNaOH+50mM乙酸钠+0.5%乙二胺 ', '7', '0', 'NaOH', '乙酸钠', '乙二胺', '', '100', '50', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-15', 'SH-AC-15', '150mm*4.6mm', '1.5', '35', '0', '40 mM NaOH', '210', '1', 'NaOH', '', '', '', '40', '0', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-16', 'SH-AC-16', '250mm*4.6mm', '1', '35', '1', 'NaOH', '180', '1', 'NaOH', '', '', '', '0', '0', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-17', 'SH-AC-17', '250mm*4.6mm', '1.5', '35', '0', '5.0mM NaOH  ', '75', '1', 'NaOH', '', '', '', '5', '0', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-18', 'SH-AC-18', '250mm*4.6mm', '1', '35', '0', '3.0mM Na2CO3+8.0mM NaHCO3', '75', '0', 'Na2CO3', 'NaHCO3', '', '', '3', '8', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-19', 'SH-AC-19', '200mm*2.1mm', '0.1', '35', '0', '14mM KOH', '20', '1', 'KOH', '', '', '', '14', '0', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-20', 'SH-AC-20', '2.1mm*150mm', '0.15', '35', '0', '4.8mM Na2CO3+6.0mM NaHCO3', '20', '0', 'Na2CO3', 'NaHCO3', '', '', '4.8', '6', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-21', 'SH-AC-21', '200mm*2.1mm', '0.2', '35', '0', '4.8mM Na2CO3+3.6mM NaHCO3', '30', '0', 'Na2CO3', 'NaHCO3', '', '', '4.8', '3.6', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-3', 'SH-AC-3', '250mm*4.0mm', '1', '35', '0', '2.4mM Na2CO3+1mM NaHCO3 ', '75', '0', 'Na2CO3', 'NaHCO3', '', '', '2.4', '1', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-4', 'SH-AC-4', '250mm*4.6mm', '1.5', '35', '0', '2.0mM Na2CO3+10mM NaHCO3 ', '75', '0', 'Na2CO3', 'NaHCO3', '', '', '2', '10', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-5', 'SH-AC-5', '250mm*4.6mm', '0.6', '40', '0', '18mM NaOH', '75', '1', 'NaOH', '', '', '', '18', '0', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-7', 'SH-AC-7', '250mm*4.6mm', '2', '35', '0', '3.6mM Na2CO3+4.5mM NaHCO3 ', '75', '0', 'Na2CO3', 'NaHCO3', '', '', '3.6', '4.5', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AC-9', 'SH-AC-9', '250mm*4.6mm', '0.6', '40', '0', '1.5mM Na2CO3 ', '75', '1', 'Na2CO3', '', '', '', '1.5', '0', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AP-1', 'SH-AP-1', '250mm*4.0mm', '0.7', '35', '0', '15mM KOH', '75', '1', 'KOH', '', '', '', '15', '0', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AP-2', 'SH-AP-2', '250mm*4.0mm', '0.7', '35', '0', '4.8mM Na2CO3+3.6mM NaHCO3 ', '75', '0', 'Na2CO3', 'NaHCO3', '', '', '4.8', '3.6', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-AP-3', 'SH-AP-3', '150mm*4.0mm', '1.4', '35', '0', '4.8mM Na2CO3+3.6mM NaHCO3', '75', '0', 'Na2CO3', 'NaHCO3', '', '', '4.8', '3.6', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-CC-3', 'SH-CC-3', '100mm*4.6mm', '1', '35', '0', '5.0 mM MSA', '15', '1', 'MSA', '0', '0', '0', '5', '0', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-CC-3L ', 'SH-CC-3L ', '250mm*4.6mm', '1', '35', '0', '5.0 mM MSA', '15', '1', 'MSA', '0', '0', '0', '5', '0', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-CC-4', 'SH-CC-4', '200mm*4.0mm', '1', '35', '0', '5.0 mM MSA', '15', '1', 'MSA', '0', '0', '0', '5', '0', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-CC-6', 'SH-CC-6', '3.0mm*250mm', '0.5', '35', '0', '5.0 mM MSA', '15', '1', 'MSA', '0', '0', '0', '5', '0', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-CC-7 ', 'SH-CC-7', '200mm*2.1mm', '0.1', '35', '0', '6.5 mM MSA', '0', '1', 'MSA', '0', '0', '0', '6.5', '0', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-CC-8', 'SH-CC-8', '250mm*3.0mm', '1', '35', '0', '5.0 mM MSA', '0', '1', 'MSA', '0', '0', '0', '5', '0', '0', '0');
INSERT INTO `tb_columninfo` VALUES ('SH-CC-9', 'SH-CC-9', '250mm*4.6mm', '1', '35', '0', '5.0 mM MSA', '15', '1', 'MSA', '0', '0', '0', '5', '0', '0', '0');

-- ----------------------------
-- Table structure for tb_device
-- ----------------------------
DROP TABLE IF EXISTS `tb_device`;
CREATE TABLE `tb_device` (
  `InstrumentGuid` char(36) NOT NULL,
  `Guid` char(36) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `Type` int(11) NOT NULL,
  `ConnType` int(11) NOT NULL DEFAULT '0' COMMENT '0, COM;1,TCP',
  PRIMARY KEY (`Guid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_device
-- ----------------------------

-- ----------------------------
-- Table structure for tb_deviceautostart
-- ----------------------------
DROP TABLE IF EXISTS `tb_deviceautostart`;
CREATE TABLE `tb_deviceautostart` (
  `DeviceGuid` char(36) NOT NULL,
  `Index` int(11) NOT NULL,
  `Module` varchar(255) NOT NULL,
  `SubDeviceType` int(11) NOT NULL,
  `Param` varchar(255) NOT NULL,
  `Value` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_deviceautostart
-- ----------------------------

-- ----------------------------
-- Table structure for tb_deviceprotect
-- ----------------------------
DROP TABLE IF EXISTS `tb_deviceprotect`;
CREATE TABLE `tb_deviceprotect` (
  `DeviceGuid` char(36) NOT NULL,
  `Index` int(11) NOT NULL,
  `Module` varchar(255) NOT NULL,
  `SubDeviceType` int(11) NOT NULL,
  `Param` varchar(255) NOT NULL,
  `Value` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_deviceprotect
-- ----------------------------

-- ----------------------------
-- Table structure for tb_deviceproxy
-- ----------------------------
DROP TABLE IF EXISTS `tb_deviceproxy`;
CREATE TABLE `tb_deviceproxy` (
  `InstrumentGuid` char(36) NOT NULL,
  `SourceGuid` char(36) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `Proxy` int(11) NOT NULL DEFAULT '0' COMMENT '0, COM;1,TCP',
  PRIMARY KEY (`Guid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_deviceproxy
-- ----------------------------

-- ----------------------------
-- Table structure for tb_devicesetupinfo
-- ----------------------------
DROP TABLE IF EXISTS `tb_devicesetupinfo`;
CREATE TABLE `tb_devicesetupinfo` (
  `DeviceGuid` char(36) NOT NULL,
  `SubDeviceType` int(11) NOT NULL,
  `Param` varchar(255) NOT NULL,
  `Value` varchar(255) NOT NULL,
  `Value2` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_devicesetupinfo
-- ----------------------------

-- ----------------------------
-- Table structure for tb_devicesource
-- ----------------------------
DROP TABLE IF EXISTS `tb_devicesource`;
CREATE TABLE `tb_devicesource` (
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Type` int(11) NOT NULL,
  `ConnType` int(11) NOT NULL DEFAULT '0' COMMENT '0, COM;1,TCP',
  `Count` int(11) NOT NULL,
  PRIMARY KEY (`Guid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_devicesource
-- ----------------------------

-- ----------------------------
-- Table structure for tb_devicesourceproxy
-- ----------------------------
DROP TABLE IF EXISTS `tb_devicesourceproxy`;
CREATE TABLE `tb_devicesourceproxy` (
  `DeviceGuid` char(36) NOT NULL,
  `Name` varchar(255) NOT NULL,
  `Type` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_devicesourceproxy
-- ----------------------------

-- ----------------------------
-- Table structure for tb_deviceuserprog
-- ----------------------------
DROP TABLE IF EXISTS `tb_deviceuserprog`;
CREATE TABLE `tb_deviceuserprog` (
  `DeviceGuid` char(36) NOT NULL,
  `Index` int(11) NOT NULL,
  `Module` varchar(255) NOT NULL,
  `SubDeviceType` int(11) NOT NULL,
  `Param` varchar(255) NOT NULL,
  `Value` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_deviceuserprog
-- ----------------------------

-- ----------------------------
-- Table structure for tb_exception
-- ----------------------------
DROP TABLE IF EXISTS `tb_exception`;
CREATE TABLE `tb_exception` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `InstrumentGuid` char(36) NOT NULL,
  `SubModuleName` varchar(255) NOT NULL,
  `Content` varchar(500) CHARACTER SET gbk NOT NULL,
  `CreateTime` datetime NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=552 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_exception
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_calibrate
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_calibrate`;
CREATE TABLE `tb_export_calibrate` (
  `ID` int(11) NOT NULL DEFAULT '0',
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `BCalculate` int(11) NOT NULL DEFAULT '0' COMMENT '是否运算',
  `CreateTime` datetime NOT NULL,
  `BChanged` int(11) NOT NULL,
  `ChromGuid` char(36) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_calibrate
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_calibratechrom
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_calibratechrom`;
CREATE TABLE `tb_export_calibratechrom` (
  `CalibrateGuid` char(36) NOT NULL,
  `ChromGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `SampleName` varchar(255) CHARACTER SET gbk NOT NULL,
  `SampleType` int(11) NOT NULL COMMENT '样品类型',
  `CalibrateLevel` int(11) NOT NULL COMMENT '校准等级',
  `HalfPeakWidth` double DEFAULT NULL,
  `Slope` double DEFAULT NULL,
  `Drift` double DEFAULT NULL,
  `TDBL` double DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_calibratechrom
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_calibratechrompeak
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_calibratechrompeak`;
CREATE TABLE `tb_export_calibratechrompeak` (
  `CalibrateGuid` char(36) NOT NULL,
  `ChromGuid` char(36) NOT NULL,
  `ChromRetainTime` double NOT NULL,
  `RetainTime` double NOT NULL,
  `Name` varchar(10) CHARACTER SET gbk NOT NULL COMMENT '元素名称',
  `Type` int(11) NOT NULL COMMENT '	ST_Unknow,\r\n	ST_Std,',
  `Level` int(11) NOT NULL,
  `Area` double NOT NULL,
  `Height` double NOT NULL,
  `X` double NOT NULL,
  `Y` double NOT NULL,
  `XUnit` varchar(255) NOT NULL,
  `YUnit` varchar(255) NOT NULL COMMENT '校准等级',
  `ResponseFactor` double NOT NULL COMMENT '响应因子',
  `CorrectFactor` double NOT NULL COMMENT '校正因子',
  `bCalc` int(11) NOT NULL DEFAULT '0' COMMENT '是否参与定量计算',
  `ResponseBase` int(11) NOT NULL,
  `TargetType` int(11) NOT NULL,
  `ISTDVol` double NOT NULL,
  `ForceName` varchar(255) CHARACTER SET gbk NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_calibratechrompeak
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_calibratechrompeakunknow
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_calibratechrompeakunknow`;
CREATE TABLE `tb_export_calibratechrompeakunknow` (
  `CalibrateGuid` char(36) NOT NULL,
  `ChromGuid` char(36) NOT NULL,
  `ChromRetainTime` double NOT NULL,
  `RetainTime` double NOT NULL,
  `Name` varchar(10) CHARACTER SET gbk NOT NULL COMMENT '元素名称',
  `Type` int(11) NOT NULL COMMENT '	ST_Unknow,\r\n	ST_Std,',
  `Level` int(11) NOT NULL,
  `Area` double NOT NULL,
  `Height` double NOT NULL,
  `X` double NOT NULL,
  `Y` double NOT NULL,
  `XUnit` varchar(255) CHARACTER SET gbk NOT NULL,
  `YUnit` varchar(255) CHARACTER SET gbk NOT NULL,
  `ResponseFactor` double NOT NULL COMMENT '响应因子',
  `CorrectFactor` double NOT NULL COMMENT '校正因子',
  `bCalc` int(11) NOT NULL DEFAULT '0' COMMENT '是否参与定量计算',
  `ResponseBase` int(11) NOT NULL,
  `TargetType` int(11) NOT NULL,
  `ISTDVol` double NOT NULL,
  `ForceName` varchar(255) CHARACTER SET gbk NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_calibratechrompeakunknow
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_calibratechromunknow
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_calibratechromunknow`;
CREATE TABLE `tb_export_calibratechromunknow` (
  `CalibrateGuid` char(36) NOT NULL,
  `ChromGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `SampleName` varchar(255) CHARACTER SET gbk NOT NULL,
  `SampleType` int(11) NOT NULL COMMENT '样品类型',
  `CalibrateLevel` int(11) NOT NULL COMMENT '校准等级',
  `HalfPeakWidth` double DEFAULT NULL,
  `Slope` double DEFAULT NULL,
  `Drift` double DEFAULT NULL,
  `TDBL` double DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_calibratechromunknow
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_calibratecompoundinfo
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_calibratecompoundinfo`;
CREATE TABLE `tb_export_calibratecompoundinfo` (
  `CalibrateGuid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `RetainTime` double NOT NULL COMMENT '保留时间',
  `Area` double NOT NULL,
  `Height` double NOT NULL,
  `Concents` varchar(300) NOT NULL,
  `ISTDGroupID` int(11) NOT NULL DEFAULT '1',
  `k` double DEFAULT NULL,
  `b` double DEFAULT NULL,
  `r` double DEFAULT NULL,
  `TargetType` int(11) NOT NULL,
  `k2` double DEFAULT NULL,
  `k3` double DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_calibratecompoundinfo
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_calibratecompoundinfoquantify
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_calibratecompoundinfoquantify`;
CREATE TABLE `tb_export_calibratecompoundinfoquantify` (
  `CalibrateGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `QualitativeType` int(11) NOT NULL COMMENT '	QLT_TimeWindow,\r\n	QLT_TimeBand',
  `WindowValue` double NOT NULL,
  `BandValue` double NOT NULL,
  `QuantifyType` int(11) NOT NULL COMMENT '定量方法类型：QMT_Normalization,//归一\r\nQMT_ESTD,	// 外标法\r\nQMT_ISTD,	// 内标法\r\nQMT_ASTD,	// 标准加入法',
  `ResponseBase` int(11) NOT NULL COMMENT '响应基础：RB_Area,	 RB_Height',
  `CarlibrateCount` int(11) NOT NULL COMMENT '校准点数',
  `CurveFitType` int(11) NOT NULL COMMENT '曲线拟合类型：0 线性',
  `Origin` int(11) NOT NULL COMMENT '原点：OP_Without, \r\nOP_Calc,\r\nOP_Pass',
  `WeightMethod` int(11) NOT NULL COMMENT '权重方法：0，无',
  `Unit` varchar(10) CHARACTER SET gbk NOT NULL,
  `BEraseEmpty` int(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_calibratecompoundinfoquantify
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_chromatogram
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_chromatogram`;
CREATE TABLE `tb_export_chromatogram` (
  `Guid` char(36) NOT NULL,
  `TaskGuid` char(36) NOT NULL,
  `SeqGuid` char(36) NOT NULL,
  `ProjectGuid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `SampleName` varchar(255) CHARACTER SET gbk NOT NULL,
  `SampleType` int(11) NOT NULL COMMENT '0, ST_Unknow,;1, ST_Std,',
  `CreateTime` datetime NOT NULL,
  `EndTime` datetime NOT NULL,
  `AnalyseGuid` char(36) NOT NULL,
  `AnalyseName` varchar(255) CHARACTER SET gbk NOT NULL,
  `State` int(11) NOT NULL DEFAULT '0' COMMENT '状态：0，running；1， finished',
  `LoopCount` int(11) NOT NULL,
  `InjectVol` int(11) NOT NULL,
  `InjectTime` int(11) NOT NULL,
  `VialNum` int(11) NOT NULL,
  `CurIndex` int(11) NOT NULL DEFAULT '0',
  `FileName` varchar(255) CHARACTER SET gbk NOT NULL,
  `CalibrateGuid` char(36) NOT NULL DEFAULT '',
  `YUnit` int(11) NOT NULL DEFAULT '18' COMMENT '	UL_One = 1,	// 1\r\n	UL_m,	// 毫\r\n	UL_u,	// 微\r\n	UL_n,	// 纳\r\n	UL_K,	// 千\r\n	UL_M,	// 兆\r\n\r\n	UD_SCM	= 16,		// 西门子/cm\r\n	UD_V	= 32,		// 电压\r\n};',
  `YUnitStr` varchar(255) CHARACTER SET gbk NOT NULL,
  `LastModifyTime` datetime NOT NULL,
  `BIntegral` int(11) NOT NULL DEFAULT '0' COMMENT '是否积分',
  `SampleVol` double NOT NULL,
  `DilFactor` double NOT NULL,
  `ISTDVol` double NOT NULL COMMENT '内标量',
  `PrintTemplateGuid` char(36) NOT NULL,
  `SSTGuid` char(36) DEFAULT NULL,
  `showheaders` varchar(50) NOT NULL,
  `HZ` int(11) NOT NULL DEFAULT '5',
  `bDel` int(1) NOT NULL DEFAULT '0',
  `MateVol` double NOT NULL DEFAULT '1',
  `SampleID` varchar(255) CHARACTER SET gbk NOT NULL,
  `CheckCode` char(36) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_chromatogram
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_chromatogramext
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_chromatogramext`;
CREATE TABLE `tb_export_chromatogramext` (
  `ChromGuid` char(36) NOT NULL,
  `RangeMax` double DEFAULT NULL,
  `RangeMin` double DEFAULT NULL,
  `CalcStd` int(1) NOT NULL DEFAULT '0',
  `RangeMaxX` double DEFAULT NULL,
  `RangeMinX` double DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_chromatogramext
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_chromdatas
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_chromdatas`;
CREATE TABLE `tb_export_chromdatas` (
  `ChromGuid` char(36) NOT NULL,
  `VarType` int(11) NOT NULL COMMENT '数据类型：1，整数；2，浮点数；3，字符串,4时间',
  `MType` int(11) NOT NULL COMMENT ' MT_Liquid = 0x10, \r\n MT_Supp  = 0x11, \r\n MT_Detector = 0x12, \r\n MT_Temp  = 0x13, \r\n MT_Eluent = 0x14,\r\n MT_Auxiliary= 0x15,\r\n MT_Pump  = 0x16,\r\n MT_AS  = 0x20, \r\n MT_Gas  = 0x30,',
  `VarName` varchar(255) CHARACTER SET gbk NOT NULL,
  `datas` longblob NOT NULL,
  `Size` int(11) NOT NULL,
  `SubVarName` varchar(10) NOT NULL COMMENT '一个模块可能产生多个值，比如：泵 （流速、压力）'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_chromdatas
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_chromdatasslopecurve
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_chromdatasslopecurve`;
CREATE TABLE `tb_export_chromdatasslopecurve` (
  `ChromGuid` char(36) NOT NULL,
  `datasslope` longblob NOT NULL,
  `datascurve` longblob NOT NULL,
  `Size` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_chromdatasslopecurve
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_chromintegralnew
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_chromintegralnew`;
CREATE TABLE `tb_export_chromintegralnew` (
  `ID` int(11) NOT NULL DEFAULT '0',
  `ChromGuid` char(36) NOT NULL,
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `Width` double DEFAULT NULL,
  `Slope` double DEFAULT NULL,
  `Drift` double DEFAULT NULL,
  `TDBL` double DEFAULT NULL,
  `MinHeight` double NOT NULL,
  `MinArea` double NOT NULL,
  `baselinechromguid` char(36) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_chromintegralnew
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_chromintegralop
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_chromintegralop`;
CREATE TABLE `tb_export_chromintegralop` (
  `ID` int(11) NOT NULL DEFAULT '0',
  `IntegralGuid` char(36) NOT NULL,
  `Guid` char(36) NOT NULL,
  `Name` varchar(50) CHARACTER SET gbk NOT NULL,
  `OpType` int(11) NOT NULL COMMENT 'COP_Delete, //删除峰\r\n	COP_PeakSeparation, //峰谷分离\r\n	COP_VerticalSeparation, //垂直分离\r\n	COP_HorizontalForward, //水平向前\r\n	COP_HorizontalBack, //水平向后\r\n	COP_TangentForward, //前切线\r\n	COP_TangentBack, //后切线\r\n	COP_ConvertNegativePeak, //转换负峰\r\n	COP_CutNegativePeak, //剪切负峰\r\n	COP_DiscardNegativePeak, //舍弃负峰\r\n	//允许交差\r\n	//删除脉冲\r\n\r\n	COP_PeakStart, //峰起点\r\n	COP_PeakEnd, //峰终点\r\n	COP_PeakSeprationPos, //分界点\r\n	COP_AddPeak, //添加正峰\r\n	COP_AddNegativePeak, //添加负峰\r\n	COP_PeakName, //强制峰命名\r\n	COP_SolventPeak, //溶剂峰',
  `StartOpX` double DEFAULT NULL,
  `StartOpY` double DEFAULT NULL,
  `StartOpIndex` int(11) DEFAULT NULL,
  `EndOpX` double DEFAULT NULL,
  `EndOpY` double DEFAULT NULL,
  `EndOpIndex` int(11) DEFAULT NULL,
  `Value` double DEFAULT NULL,
  `ChromGuid` char(36) NOT NULL,
  `SortIndex` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_chromintegralop
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_chrommed
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_chrommed`;
CREATE TABLE `tb_export_chrommed` (
  `AnalyseGuid` char(36) NOT NULL,
  `VarName` varchar(255) DEFAULT NULL,
  `value` varchar(1000) DEFAULT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Type` int(11) NOT NULL,
  `ModuleDeviceGuid` char(36) NOT NULL,
  `ChromGuid` char(36) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_chrommed
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_chrommedmain
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_chrommedmain`;
CREATE TABLE `tb_export_chrommedmain` (
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `InstrumentGuid` char(36) NOT NULL,
  `ChromGuid` char(36) NOT NULL,
  `ColumnParam` varchar(255) CHARACTER SET gbk NOT NULL COMMENT '色谱柱参数',
  `MobilePhase` varchar(255) CHARACTER SET gbk NOT NULL COMMENT '流动相'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_chrommedmain
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_peakfpoint
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_peakfpoint`;
CREATE TABLE `tb_export_peakfpoint` (
  `ChromGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `Type` int(11) NOT NULL,
  `XIndex` int(11) NOT NULL,
  `X` double NOT NULL,
  `Y` double NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_peakfpoint
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_peakridings
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_peakridings`;
CREATE TABLE `tb_export_peakridings` (
  `ChromGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `bNew` int(11) NOT NULL DEFAULT '0',
  `bDel` int(11) NOT NULL DEFAULT '0',
  `HorzType` int(11) NOT NULL COMMENT '	OT_Null,\r\n	OT_HorzForward,\r\n	OT_HorzBackWard',
  `RidingType` int(11) NOT NULL COMMENT 'RT_Null,\r\nRT_Child = 1,	//骑峰的子峰\r\nRT_ParentForward = 2,	//骑峰的母峰\r\nRT_ParentBackward = 4',
  `ParentRetainTime` double NOT NULL,
  `TargetType` int(11) NOT NULL DEFAULT '0' COMMENT 'enum TargetType\r\n{\r\n	TT_Target,	// 目标峰\r\n	TT_ISTD,	// 内标峰\r\n	TT_Refer,	// 参考峰\r\n};',
  `ISTDVol` double NOT NULL DEFAULT '0' COMMENT '内标物含量'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_peakridings
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_peaks
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_peaks`;
CREATE TABLE `tb_export_peaks` (
  `ChromGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `Height` double NOT NULL,
  `Width` double NOT NULL,
  `WidthHalfHeight` double NOT NULL,
  `Area` double NOT NULL,
  `TheoreticalPlateNumber` double NOT NULL,
  `TheoreticalPlateHeight` double NOT NULL,
  `EffectivePlateNumber` double NOT NULL,
  `Invalid` int(11) NOT NULL DEFAULT '0',
  `bNew` int(11) NOT NULL DEFAULT '0',
  `bDel` int(11) NOT NULL DEFAULT '0',
  `HorzType` int(11) NOT NULL COMMENT '	OT_Null,\r\n	OT_HorzForward,\r\n	OT_HorzBackWard',
  `RidingType` int(11) NOT NULL COMMENT 'RT_Null,\r\nRT_Child = 1,	//骑峰的子峰\r\nRT_ParentForward = 2,	//骑峰的母峰\r\nRT_ParentBackward = 4',
  `TargetType` int(11) NOT NULL DEFAULT '0' COMMENT 'enum TargetType\r\n{\r\n	TT_Target,	// 目标峰\r\n	TT_ISTD,	// 内标峰\r\n	TT_Refer,	// 参考峰\r\n};',
  `ISTDVol` double NOT NULL DEFAULT '0' COMMENT '内标物含量',
  `ForceName` varchar(255) CHARACTER SET gbk NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_peaks
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_peakshape
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_peakshape`;
CREATE TABLE `tb_export_peakshape` (
  `ChromGuid` char(36) NOT NULL,
  `ShapeGuid` char(36) NOT NULL,
  `ShapeType` int(11) NOT NULL COMMENT '		PS_None,\r\n		PS_Single,\r\n		PS_OverLap',
  `HorzType` int(11) NOT NULL DEFAULT '0' COMMENT 'enum HorzType\r\n{\r\n	OT_Null,\r\n	OT_HorzForward,\r\n	OT_HorzBackWard\r\n};'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_peakshape
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_peakshape_peaks
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_peakshape_peaks`;
CREATE TABLE `tb_export_peakshape_peaks` (
  `ShapeGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `RidingType` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_peakshape_peaks
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_seq
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_seq`;
CREATE TABLE `tb_export_seq` (
  `ID` int(11) NOT NULL DEFAULT '0',
  `Guid` char(36) NOT NULL,
  `ProjectGuid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `bDel` int(11) NOT NULL DEFAULT '0',
  `Mode` int(11) NOT NULL,
  `ShutDown` int(11) NOT NULL DEFAULT '0',
  `InstrumentGuid` char(36) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_seq
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_task
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_task`;
CREATE TABLE `tb_export_task` (
  `ID` int(11) NOT NULL DEFAULT '0',
  `Guid` char(36) NOT NULL,
  `SeqGuid` char(36) NOT NULL,
  `bCheck` int(11) NOT NULL,
  `SampleID` varchar(255) CHARACTER SET gbk NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `LoopCount` int(11) NOT NULL,
  `InjectVol` int(11) NOT NULL,
  `InjectTime` int(11) NOT NULL,
  `VialNum` int(11) NOT NULL,
  `SampleType` int(11) NOT NULL COMMENT '0 未知样品；1 标准样品;2 空白样品',
  `MedGuid` char(36) DEFAULT NULL COMMENT '冗余方法信息',
  `MedName` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `ChromName` varchar(255) CHARACTER SET gbk NOT NULL,
  `ChromPath` varchar(255) CHARACTER SET gbk NOT NULL,
  `State` int(11) NOT NULL COMMENT 'ICTS_NULL, ICTS_Run, ICTS_Pause, ICTS_Stop, ICTS_Finish, ICTS_Exec',
  `CurIndex` int(11) NOT NULL DEFAULT '0',
  `bDel` int(11) NOT NULL DEFAULT '0',
  `SortIndex` int(11) NOT NULL,
  `Massic` double NOT NULL DEFAULT '1',
  `Dilute` double NOT NULL DEFAULT '1',
  `MateVol` double NOT NULL DEFAULT '1',
  `IntegralGuid` char(36) NOT NULL,
  `CalibrateGuid` char(36) NOT NULL,
  `PrintTemplateGuid` char(36) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_task
-- ----------------------------

-- ----------------------------
-- Table structure for tb_export_useroperate
-- ----------------------------
DROP TABLE IF EXISTS `tb_export_useroperate`;
CREATE TABLE `tb_export_useroperate` (
  `ID` int(11) NOT NULL DEFAULT '0',
  `UserGuid` char(36) NOT NULL,
  `UserName` varchar(255) CHARACTER SET gbk NOT NULL,
  `ClassGuid` char(36) NOT NULL,
  `ClassName` varchar(255) CHARACTER SET gbk NOT NULL,
  `OperateModule` int(11) NOT NULL,
  `ModuleName` varchar(255) CHARACTER SET gbk NOT NULL,
  `OldValue` varchar(255) CHARACTER SET gbk NOT NULL,
  `NewValue` varchar(255) CHARACTER SET gbk NOT NULL,
  `Reason` varchar(255) CHARACTER SET gbk NOT NULL,
  `Content` varchar(255) CHARACTER SET gbk NOT NULL,
  `OpTime` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_export_useroperate
-- ----------------------------

-- ----------------------------
-- Table structure for tb_instrument
-- ----------------------------
DROP TABLE IF EXISTS `tb_instrument`;
CREATE TABLE `tb_instrument` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `bDel` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`,`Guid`)
) ENGINE=MyISAM AUTO_INCREMENT=121 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_instrument
-- ----------------------------

-- ----------------------------
-- Table structure for tb_instrument_filter
-- ----------------------------
DROP TABLE IF EXISTS `tb_instrument_filter`;
CREATE TABLE `tb_instrument_filter` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(64) CHARACTER SET gbk NOT NULL,
  `InstrumentGuid` char(36) NOT NULL,
  `ProjectGuid` char(36) NOT NULL,
  `ParentID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_instrument_filter
-- ----------------------------

-- ----------------------------
-- Table structure for tb_integralinfo
-- ----------------------------
DROP TABLE IF EXISTS `tb_integralinfo`;
CREATE TABLE `tb_integralinfo` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `Width` double DEFAULT NULL,
  `Slope` double DEFAULT NULL,
  `Drift` double DEFAULT NULL,
  `TDBL` double DEFAULT NULL,
  `MinHeight` double NOT NULL DEFAULT '0',
  `MinArea` double NOT NULL DEFAULT '0',
  `UpCount` int(11) NOT NULL DEFAULT '8',
  `baselinechromguid` char(36) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_integralinfo
-- ----------------------------

-- ----------------------------
-- Table structure for tb_integralop
-- ----------------------------
DROP TABLE IF EXISTS `tb_integralop`;
CREATE TABLE `tb_integralop` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `IntegralGuid` char(36) NOT NULL,
  `Name` varchar(50) CHARACTER SET gbk NOT NULL,
  `OpType` int(11) NOT NULL COMMENT 'COP_Delete, //删除峰\r\n	COP_PeakSeparation, //峰谷分离\r\n	COP_VerticalSeparation, //垂直分离\r\n	COP_HorizontalForward, //水平向前\r\n	COP_HorizontalBack, //水平向后\r\n	COP_TangentForward, //前切线\r\n	COP_TangentBack, //后切线\r\n	COP_ConvertNegativePeak, //转换负峰\r\n	COP_CutNegativePeak, //剪切负峰\r\n	COP_DiscardNegativePeak, //舍弃负峰\r\n	//允许交差\r\n	//删除脉冲\r\n\r\n	COP_PeakStart, //峰起点\r\n	COP_PeakEnd, //峰终点\r\n	COP_PeakSeprationPos, //分界点\r\n	COP_AddPeak, //添加正峰\r\n	COP_AddNegativePeak, //添加负峰\r\n	COP_PeakName, //强制峰命名\r\n	COP_SolventPeak, //溶剂峰',
  `StartOpX` double NOT NULL,
  `StartOpY` double NOT NULL,
  `StartOpIndex` int(11) NOT NULL,
  `EndOpX` double NOT NULL,
  `EndOpY` double NOT NULL,
  `EndOpIndex` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=145 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_integralop
-- ----------------------------

-- ----------------------------
-- Table structure for tb_moduledevice
-- ----------------------------
DROP TABLE IF EXISTS `tb_moduledevice`;
CREATE TABLE `tb_moduledevice` (
  `Guid` char(36) NOT NULL,
  `Type` int(11) NOT NULL COMMENT ' MT_Liquid = 0x10, \r\n MT_Supp  = 0x11, \r\n MT_Detector = 0x12, \r\n MT_Temp  = 0x13, \r\n MT_Eluent = 0x14,\r\n MT_Auxiliary= 0x15,\r\n MT_Pump  = 0x16,\r\n MT_AS  = 0x20, \r\n MT_Gas  = 0x30,',
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `ConnType` int(11) NOT NULL DEFAULT '0' COMMENT '0, COM;1,TCP',
  `DevNo` int(11) NOT NULL,
  `GroupID` int(11) NOT NULL DEFAULT '0',
  `GroupName` varchar(255) NOT NULL,
  PRIMARY KEY (`Guid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_moduledevice
-- ----------------------------
INSERT INTO `tb_moduledevice` VALUES ('6EECA28B-C065-43F9-8371-F71FC9388370', '16', 'CIC-D100', '0', '1', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('8C359A6E-6FEB-4FAA-8258-6183F0CA71C3', '32', 'SHA-12', '0', '0', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('F7105971-3246-4FB5-AFCB-9FFBA72567F3', '20', 'SHRF-10', '0', '13', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('9C179359-B063-4615-9BD9-228940FD0F3C', '16', 'CIC-D180', '0', '31', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('72889440-446B-4C0F-871C-AB8AF298A72E', '16', 'CIC-D160', '0', '3', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('A2CA1033-1D1F-4B04-8D99-3F86A6BA1865', '16', 'CIC-D120', '0', '2', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('B1A4F916-8258-4649-BE18-9A9CEC2F95A2', '16', 'CIC-D150', '0', '30', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('7BA672CF-E1AB-4FE4-A7CD-00760B772128', '32', 'SHA-7', '0', '26', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('4CC844F7-B8AD-45CA-A864-EF5E7CCEC074', '32', 'SHA-17', '0', '0', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('E81EDBEF-B79E-4FD8-8C90-79654DC8EC1F', '32', 'SHA-16', '0', '0', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('E8359B2B-F410-4B15-AC0C-7F56F8CE5B7D', '18', 'SHE-2', '0', '0', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('1CCDF9D6-9D43-4D5C-B0C3-48CB451BFB94', '32', 'SHA-12D', '0', '0', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('BBD89669-CCD3-4DA3-9D5C-67A53F257ECE', '18', 'SHE-8', '0', '0', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('5A383C19-49C4-44F7-8AF0-78A64B0069F1', '16', 'CIC-D300A', '0', '3', '1', 'CIC-D300');
INSERT INTO `tb_moduledevice` VALUES ('8A51F60A-823A-4483-B0C5-29F044056557', '16', 'CIC-D300B', '0', '3', '1', 'CIC-D300');
INSERT INTO `tb_moduledevice` VALUES ('6AB7C0A9-2BE3-4652-9815-460724783B12', '16', 'CIC-D300PlusA', '0', '300', '2', 'CIC-D300Plus');
INSERT INTO `tb_moduledevice` VALUES ('BCF124C0-419A-4CCD-8001-85B6C4DD184A', '16', 'CIC-D300PlusB', '0', '300', '2', 'CIC-D300Plus');
INSERT INTO `tb_moduledevice` VALUES ('651E0E4A-1765-4B36-B042-75AF2C37847E', '16', 'AzuraPump P 6.1L', '1', '0', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('274E1AC2-DD50-4D25-B275-84D99CBD074F', '16', 'CIC-D180Valve', '0', '0', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('9C63B472-16C4-4A41-8E6F-D36AA54EC84C', '16', 'SHP-21', '0', '0', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('7A7E254E-463A-4B8E-ACD0-F8F8D3D95777', '18', 'SHUV-21', '0', '0', '0', '');
INSERT INTO `tb_moduledevice` VALUES ('5060AA3F-F233-46BD-88AA-11D666076715', '16', 'CIC_D300Simple', '0', '0', '3', 'CIC-D300Simple');
INSERT INTO `tb_moduledevice` VALUES ('A6DD6E11-3309-4F3D-B8F0-18EB053DD5FC', '16', 'CIC_D300SimpleB', '0', '0', '3', 'CIC-D300Simple');

-- ----------------------------
-- Table structure for tb_moduledeviceproxy
-- ----------------------------
DROP TABLE IF EXISTS `tb_moduledeviceproxy`;
CREATE TABLE `tb_moduledeviceproxy` (
  `DeviceGuid` char(36) NOT NULL,
  `Name` varchar(255) NOT NULL,
  `Type` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_moduledeviceproxy
-- ----------------------------
INSERT INTO `tb_moduledeviceproxy` VALUES ('1CCDF9D6-9D43-4D5C-B0C3-48CB451BFB94', 'AS12D-A', '1');
INSERT INTO `tb_moduledeviceproxy` VALUES ('1CCDF9D6-9D43-4D5C-B0C3-48CB451BFB94', 'AS12D-B', '2');
INSERT INTO `tb_moduledeviceproxy` VALUES ('E81EDBEF-B79E-4FD8-8C90-79654DC8EC1F', 'AS16-Valve', '11');
INSERT INTO `tb_moduledeviceproxy` VALUES ('E81EDBEF-B79E-4FD8-8C90-79654DC8EC1F', 'AS16-ISS-A', '12');

-- ----------------------------
-- Table structure for tb_modulesubdevice
-- ----------------------------
DROP TABLE IF EXISTS `tb_modulesubdevice`;
CREATE TABLE `tb_modulesubdevice` (
  `Guid` char(36) NOT NULL,
  `DeviceGuid` char(36) NOT NULL,
  `Type` int(10) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  PRIMARY KEY (`Guid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_modulesubdevice
-- ----------------------------
INSERT INTO `tb_modulesubdevice` VALUES ('76E84DDA-E86F-483F-980C-06EB82601201', '6EECA28B-C065-43F9-8371-F71FC9388370', '18', 'Detector1');
INSERT INTO `tb_modulesubdevice` VALUES ('ED595C59-BCF6-412E-B2FB-716106F042D1', '6EECA28B-C065-43F9-8371-F71FC9388370', '22', 'LC1');
INSERT INTO `tb_modulesubdevice` VALUES ('E4CA78BD-2336-4700-A8E1-DA75A0CD4AC9', '6EECA28B-C065-43F9-8371-F71FC9388370', '17', 'Supp1');
INSERT INTO `tb_modulesubdevice` VALUES ('02737D2D-1029-4E49-8948-31E61FDAE5AD', '6EECA28B-C065-43F9-8371-F71FC9388370', '19', 'Temp1');
INSERT INTO `tb_modulesubdevice` VALUES ('7FF652E7-75FB-4C3B-84BB-10FF31C551C9', '8C359A6E-6FEB-4FAA-8258-6183F0CA71C3', '32', 'SHA-12');
INSERT INTO `tb_modulesubdevice` VALUES ('89A8D633-AE51-4467-B2E2-A9AA00977A6D', 'F7105971-3246-4FB5-AFCB-9FFBA72567F3', '20', 'Eluent1');
INSERT INTO `tb_modulesubdevice` VALUES ('8B398237-8B12-45FE-8680-CE3C44AFF90F', '9C179359-B063-4615-9BD9-228940FD0F3C', '22', 'LC1');
INSERT INTO `tb_modulesubdevice` VALUES ('74001FBE-7400-4937-8D7E-23946008704E', '9C179359-B063-4615-9BD9-228940FD0F3C', '18', 'Detector1');
INSERT INTO `tb_modulesubdevice` VALUES ('ED3E6128-9A5A-42D5-9772-399451F7C9E7', '9C179359-B063-4615-9BD9-228940FD0F3C', '17', 'Supp1');
INSERT INTO `tb_modulesubdevice` VALUES ('3CDC9C10-B35E-4B25-B2D7-78CCB751A6EC', '9C179359-B063-4615-9BD9-228940FD0F3C', '19', 'Temp1');
INSERT INTO `tb_modulesubdevice` VALUES ('1C13B088-2E78-4AB2-AD04-A6AF80FD5372', '9C179359-B063-4615-9BD9-228940FD0F3C', '20', 'Eluent1');
INSERT INTO `tb_modulesubdevice` VALUES ('952A5B9E-0DCC-4090-A3F7-DC7354508723', '72889440-446B-4C0F-871C-AB8AF298A72E', '18', 'Detector1');
INSERT INTO `tb_modulesubdevice` VALUES ('BF0A2797-C085-4BB8-9C8E-2ACABAA713EA', '72889440-446B-4C0F-871C-AB8AF298A72E', '22', 'LC1');
INSERT INTO `tb_modulesubdevice` VALUES ('E0CC14EA-253F-4456-A64A-B5CFF9011D98', '72889440-446B-4C0F-871C-AB8AF298A72E', '17', 'Supp1');
INSERT INTO `tb_modulesubdevice` VALUES ('77B463DA-E76D-4158-B23A-F78D7DD11DB5', '72889440-446B-4C0F-871C-AB8AF298A72E', '19', 'Temp1');
INSERT INTO `tb_modulesubdevice` VALUES ('D3354B18-0A75-446D-BBE0-DF3C5842AE25', '72889440-446B-4C0F-871C-AB8AF298A72E', '20', 'Eluent1');
INSERT INTO `tb_modulesubdevice` VALUES ('842E39E4-7973-4603-9B00-093E8E8B031B', 'B1A4F916-8258-4649-BE18-9A9CEC2F95A2', '18', 'Detector1');
INSERT INTO `tb_modulesubdevice` VALUES ('E82072BB-339A-439B-B372-EE0F90C9B2F3', 'B1A4F916-8258-4649-BE18-9A9CEC2F95A2', '22', 'LC1');
INSERT INTO `tb_modulesubdevice` VALUES ('07333568-33A4-4C93-B90C-247DC7E34288', 'B1A4F916-8258-4649-BE18-9A9CEC2F95A2', '17', 'Supp1');
INSERT INTO `tb_modulesubdevice` VALUES ('2F40E46C-B093-4591-94E9-4298A14D563D', 'B1A4F916-8258-4649-BE18-9A9CEC2F95A2', '19', 'Temp1');
INSERT INTO `tb_modulesubdevice` VALUES ('FA20A615-CB57-4FD1-AF75-EE00377511A7', 'A2CA1033-1D1F-4B04-8D99-3F86A6BA1865', '18', 'Detector1');
INSERT INTO `tb_modulesubdevice` VALUES ('66A32029-B9ED-4A78-8648-4A84B097296E', 'A2CA1033-1D1F-4B04-8D99-3F86A6BA1865', '22', 'LC1');
INSERT INTO `tb_modulesubdevice` VALUES ('EAA3F777-7D3D-4B19-B568-F59824CF0290', 'A2CA1033-1D1F-4B04-8D99-3F86A6BA1865', '17', 'Supp1');
INSERT INTO `tb_modulesubdevice` VALUES ('F1A05AA5-8C0A-4DFF-96F8-507FF666044F', 'A2CA1033-1D1F-4B04-8D99-3F86A6BA1865', '19', 'Temp1');
INSERT INTO `tb_modulesubdevice` VALUES ('B2C10E5C-8625-4F97-803A-7014CBDA76BB', '7BA672CF-E1AB-4FE4-A7CD-00760B772128', '32', 'AS7');
INSERT INTO `tb_modulesubdevice` VALUES ('F267FDA9-301D-484F-99E8-1991D0DA0EA2', '4CC844F7-B8AD-45CA-A864-EF5E7CCEC074', '32', 'AS17');
INSERT INTO `tb_modulesubdevice` VALUES ('E54FB40C-60F3-4AB1-A97E-B81E9F51912F', 'E81EDBEF-B79E-4FD8-8C90-79654DC8EC1F', '32', 'AS16');
INSERT INTO `tb_modulesubdevice` VALUES ('58E37984-BFE1-401C-9126-C098DC5D84F3', 'E8359B2B-F410-4B15-AC0C-7F56F8CE5B7D', '18', 'SHE2');
INSERT INTO `tb_modulesubdevice` VALUES ('1D3D2A96-26D0-4420-9DD1-375F37FCB202', '1CCDF9D6-9D43-4D5C-B0C3-48CB451BFB94', '32', 'SHA-12D');
INSERT INTO `tb_modulesubdevice` VALUES ('7B60DE35-BECF-43AF-BBFD-D312218C94F9', '5A383C19-49C4-44F7-8AF0-78A64B0069F1', '18', 'Detector1');
INSERT INTO `tb_modulesubdevice` VALUES ('85966018-E71A-4793-B54D-CBE55DD25CE9', '5A383C19-49C4-44F7-8AF0-78A64B0069F1', '22', 'LC1');
INSERT INTO `tb_modulesubdevice` VALUES ('11AF24D1-93BC-46C1-AD34-54B900591675', '5A383C19-49C4-44F7-8AF0-78A64B0069F1', '17', 'Supp1');
INSERT INTO `tb_modulesubdevice` VALUES ('DD2F4206-7321-40D4-9296-1E99EFFC622A', '5A383C19-49C4-44F7-8AF0-78A64B0069F1', '19', 'Temp1');
INSERT INTO `tb_modulesubdevice` VALUES ('B4DE8BD7-9045-42BC-A158-4F585B9A483B', '5A383C19-49C4-44F7-8AF0-78A64B0069F1', '20', 'Eluent1');
INSERT INTO `tb_modulesubdevice` VALUES ('B3C62E9D-9520-4461-B14A-22B8821F0503', '8A51F60A-823A-4483-B0C5-29F044056557', '18', 'Detector1');
INSERT INTO `tb_modulesubdevice` VALUES ('AC7D3CD0-259C-4162-8E3D-FED360FF60C9', '8A51F60A-823A-4483-B0C5-29F044056557', '22', 'LC1');
INSERT INTO `tb_modulesubdevice` VALUES ('B10A8E0D-FE6F-4705-ACE0-98C6DA2F2763', '8A51F60A-823A-4483-B0C5-29F044056557', '17', 'Supp1');
INSERT INTO `tb_modulesubdevice` VALUES ('560F2D88-9940-49A8-9109-D1131F4E25CB', '8A51F60A-823A-4483-B0C5-29F044056557', '19', 'Temp1');
INSERT INTO `tb_modulesubdevice` VALUES ('9915E32F-AB0B-46A8-AF54-1809832E920C', '8A51F60A-823A-4483-B0C5-29F044056557', '20', 'Eluent1');
INSERT INTO `tb_modulesubdevice` VALUES ('15106AB0-2B59-4341-90BD-66D8CBC2D558', '6AB7C0A9-2BE3-4652-9815-460724783B12', '22', 'LC1');
INSERT INTO `tb_modulesubdevice` VALUES ('E4C55DE6-D74F-439B-BC15-E4DF8F0DD0D9', '6AB7C0A9-2BE3-4652-9815-460724783B12', '18', 'Detector1');
INSERT INTO `tb_modulesubdevice` VALUES ('BF53865D-68EF-4215-A159-05C5AA572B84', '6AB7C0A9-2BE3-4652-9815-460724783B12', '17', 'Supp1');
INSERT INTO `tb_modulesubdevice` VALUES ('809DB0B2-6E63-42FF-8DD0-44303A348618', '6AB7C0A9-2BE3-4652-9815-460724783B12', '19', 'Temp1');
INSERT INTO `tb_modulesubdevice` VALUES ('392FA0D1-AF3E-4A3B-B79B-1F70A861A5D5', '6AB7C0A9-2BE3-4652-9815-460724783B12', '20', 'Eluent1');
INSERT INTO `tb_modulesubdevice` VALUES ('4DF86245-5814-4CE4-9569-1C0EBADE3BBD', 'BCF124C0-419A-4CCD-8001-85B6C4DD184A', '18', 'Detector1');
INSERT INTO `tb_modulesubdevice` VALUES ('878A5F3F-9D2D-4DD1-81CD-F79C38FB09FE', 'BCF124C0-419A-4CCD-8001-85B6C4DD184A', '22', 'LC1');
INSERT INTO `tb_modulesubdevice` VALUES ('51DE809E-C360-4C75-BAB1-249386638083', 'BCF124C0-419A-4CCD-8001-85B6C4DD184A', '17', 'Supp1');
INSERT INTO `tb_modulesubdevice` VALUES ('35C9A5CF-1595-4D43-B6D7-C759A3D85C07', 'BCF124C0-419A-4CCD-8001-85B6C4DD184A', '19', 'Temp1');
INSERT INTO `tb_modulesubdevice` VALUES ('35264F04-5082-4023-89D2-0572C2291ED8', 'BCF124C0-419A-4CCD-8001-85B6C4DD184A', '20', 'Eluent1');
INSERT INTO `tb_modulesubdevice` VALUES ('50723D5D-E68E-4E52-8A3C-2C642D5DFD03', 'BBD89669-CCD3-4DA3-9D5C-67A53F257ECE', '18', 'SHE8');
INSERT INTO `tb_modulesubdevice` VALUES ('112A13E2-4CD0-41B8-A72D-7CE26292530B', '651E0E4A-1765-4B36-B042-75AF2C37847E', '22', 'AzuraPump');
INSERT INTO `tb_modulesubdevice` VALUES ('C5AC4149-B57A-4C9F-8BC1-D33FF589A9E3', 'BCF124C0-419A-4CCD-8001-85B6C4DD184A', '22', 'LCBottom');
INSERT INTO `tb_modulesubdevice` VALUES ('C70A9348-55A5-4B79-AC48-906F94F240C8', 'BCF124C0-419A-4CCD-8001-85B6C4DD184A', '22', 'LCTop');
INSERT INTO `tb_modulesubdevice` VALUES ('6F6A49CC-5DF2-44C3-9741-8C5629414D50', 'BCF124C0-419A-4CCD-8001-85B6C4DD184A', '23', 'Valve');
INSERT INTO `tb_modulesubdevice` VALUES ('F1C89AE6-16D5-4784-A0C8-0E46AA710C61', '6AB7C0A9-2BE3-4652-9815-460724783B12', '22', 'LCTop');
INSERT INTO `tb_modulesubdevice` VALUES ('70D48D0B-12F3-4BA3-8181-DC111CEFFFE3', '6AB7C0A9-2BE3-4652-9815-460724783B12', '22', 'LCBottom');
INSERT INTO `tb_modulesubdevice` VALUES ('FEDEA3D8-0E5A-489E-B511-B08083A9823A', '6AB7C0A9-2BE3-4652-9815-460724783B12', '23', 'Valve');
INSERT INTO `tb_modulesubdevice` VALUES ('309E5FC4-405B-4B8F-8CE2-5D2BE4752E8D', '274E1AC2-DD50-4D25-B275-84D99CBD074F', '22', 'LC1');
INSERT INTO `tb_modulesubdevice` VALUES ('4E99D9FF-44D2-40E0-8B2F-609298969E9C', '274E1AC2-DD50-4D25-B275-84D99CBD074F', '18', 'Detector1');
INSERT INTO `tb_modulesubdevice` VALUES ('3CB4E6FD-0B0E-4B4F-8EB2-1562BC8B6660', '274E1AC2-DD50-4D25-B275-84D99CBD074F', '17', 'Supp1');
INSERT INTO `tb_modulesubdevice` VALUES ('51320B21-FB0D-4BDB-9DD5-5A47A5DC86FE', '274E1AC2-DD50-4D25-B275-84D99CBD074F', '19', 'Temp1');
INSERT INTO `tb_modulesubdevice` VALUES ('0F477C08-91F6-4CAD-A430-E8044D231839', '274E1AC2-DD50-4D25-B275-84D99CBD074F', '20', 'Eluent1');
INSERT INTO `tb_modulesubdevice` VALUES ('B9EBB07B-F0C7-4195-819C-5F119F62EB9A', '274E1AC2-DD50-4D25-B275-84D99CBD074F', '32', 'Valve');
INSERT INTO `tb_modulesubdevice` VALUES ('AA2D569E-21B1-46D5-83FD-09B947207A6C', '9C63B472-16C4-4A41-8E6F-D36AA54EC84C', '22', 'SHP-21');
INSERT INTO `tb_modulesubdevice` VALUES ('058CEC20-2D73-4841-911F-03D3D10F6AC4', '7A7E254E-463A-4B8E-ACD0-F8F8D3D95777', '18', 'SHUV-21');
INSERT INTO `tb_modulesubdevice` VALUES ('6C7E33CF-BA3C-43B4-90FA-B892969CBB58', '5060AA3F-F233-46BD-88AA-11D666076715', '18', 'Detector1');
INSERT INTO `tb_modulesubdevice` VALUES ('AF2A553D-D2CB-4244-BC12-08BCAA712B39', '5060AA3F-F233-46BD-88AA-11D666076715', '22', 'LC1');
INSERT INTO `tb_modulesubdevice` VALUES ('69AB7A7B-0CCC-49AD-98C5-572E06987F78', '5060AA3F-F233-46BD-88AA-11D666076715', '17', 'Supp1');
INSERT INTO `tb_modulesubdevice` VALUES ('BAD603FF-015D-445A-B784-19C277EE3E1C', '5060AA3F-F233-46BD-88AA-11D666076715', '19', 'Temp1');
INSERT INTO `tb_modulesubdevice` VALUES ('309CF7DA-50F3-4B45-92BD-FF0E09C6BC79', 'A6DD6E11-3309-4F3D-B8F0-18EB053DD5FC', '18', 'Detector1');
INSERT INTO `tb_modulesubdevice` VALUES ('0884A4E0-F85B-48F2-AFCA-4EF5C26E9CAC', 'A6DD6E11-3309-4F3D-B8F0-18EB053DD5FC', '22', 'LC1');
INSERT INTO `tb_modulesubdevice` VALUES ('D099C806-70D8-4D13-B3EE-9E1CF146D558', 'A6DD6E11-3309-4F3D-B8F0-18EB053DD5FC', '17', 'Supp1');
INSERT INTO `tb_modulesubdevice` VALUES ('0FF6CBD3-9A7F-4F44-9809-FC1C11468564', 'A6DD6E11-3309-4F3D-B8F0-18EB053DD5FC', '19', 'Temp1');

-- ----------------------------
-- Table structure for tb_modulesubdevice_copy
-- ----------------------------
DROP TABLE IF EXISTS `tb_modulesubdevice_copy`;
CREATE TABLE `tb_modulesubdevice_copy` (
  `Guid` char(36) NOT NULL,
  `DeviceGuid` char(36) NOT NULL,
  `Type` int(10) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  PRIMARY KEY (`Guid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_modulesubdevice_copy
-- ----------------------------

-- ----------------------------
-- Table structure for tb_noisedrift
-- ----------------------------
DROP TABLE IF EXISTS `tb_noisedrift`;
CREATE TABLE `tb_noisedrift` (
  `ChromGuid` char(36) NOT NULL,
  `NoiseStartIndex` int(11) DEFAULT NULL,
  `NoiseEndIndex` int(11) DEFAULT NULL,
  `NoiseP2P` double DEFAULT NULL,
  `NoiseAstm` double DEFAULT NULL,
  `NoiseSigma6` double DEFAULT NULL,
  `NoiseName` char(10) DEFAULT NULL,
  `DriftStartIndex` int(11) DEFAULT NULL,
  `DriftEndIndex` int(11) DEFAULT NULL,
  `Drift` double DEFAULT NULL,
  PRIMARY KEY (`ChromGuid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_noisedrift
-- ----------------------------

-- ----------------------------
-- Table structure for tb_peakfpoint
-- ----------------------------
DROP TABLE IF EXISTS `tb_peakfpoint`;
CREATE TABLE `tb_peakfpoint` (
  `ChromGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `Type` int(11) NOT NULL,
  `XIndex` int(11) NOT NULL,
  `X` double NOT NULL,
  `Y` double NOT NULL,
  KEY `idx_chromguid` (`ChromGuid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ROW_FORMAT=FIXED;

-- ----------------------------
-- Records of tb_peakfpoint
-- ----------------------------

-- ----------------------------
-- Table structure for tb_peakridings
-- ----------------------------
DROP TABLE IF EXISTS `tb_peakridings`;
CREATE TABLE `tb_peakridings` (
  `ChromGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `bNew` int(11) NOT NULL DEFAULT '0',
  `bDel` int(11) NOT NULL DEFAULT '0',
  `HorzType` int(11) NOT NULL COMMENT '	OT_Null,\r\n	OT_HorzForward,\r\n	OT_HorzBackWard',
  `RidingType` int(11) NOT NULL COMMENT 'RT_Null,\r\nRT_Child = 1,	//骑峰的子峰\r\nRT_ParentForward = 2,	//骑峰的母峰\r\nRT_ParentBackward = 4',
  `ParentRetainTime` double NOT NULL,
  `TargetType` int(11) NOT NULL DEFAULT '0' COMMENT 'enum TargetType\r\n{\r\n	TT_Target,	// 目标峰\r\n	TT_ISTD,	// 内标峰\r\n	TT_Refer,	// 参考峰\r\n};',
  `ISTDVol` double NOT NULL DEFAULT '0' COMMENT '内标物含量'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_peakridings
-- ----------------------------

-- ----------------------------
-- Table structure for tb_peaks
-- ----------------------------
DROP TABLE IF EXISTS `tb_peaks`;
CREATE TABLE `tb_peaks` (
  `ChromGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `Height` double NOT NULL,
  `Width` double NOT NULL,
  `WidthHalfHeight` double NOT NULL,
  `Area` double NOT NULL,
  `TheoreticalPlateNumber` double NOT NULL,
  `TheoreticalPlateHeight` double NOT NULL,
  `EffectivePlateNumber` double NOT NULL,
  `Invalid` int(11) NOT NULL DEFAULT '0',
  `bNew` int(11) NOT NULL DEFAULT '0',
  `bDel` int(11) NOT NULL DEFAULT '0',
  `HorzType` int(11) NOT NULL COMMENT '	OT_Null,\r\n	OT_HorzForward,\r\n	OT_HorzBackWard',
  `RidingType` int(11) NOT NULL COMMENT 'RT_Null,\r\nRT_Child = 1,	//骑峰的子峰\r\nRT_ParentForward = 2,	//骑峰的母峰\r\nRT_ParentBackward = 4',
  `TargetType` int(11) NOT NULL DEFAULT '0' COMMENT 'enum TargetType\r\n{\r\n	TT_Target,	// 目标峰\r\n	TT_ISTD,	// 内标峰\r\n	TT_Refer,	// 参考峰\r\n};',
  `ISTDVol` double NOT NULL DEFAULT '0' COMMENT '内标物含量',
  `ForceName` varchar(255) CHARACTER SET gbk NOT NULL,
  KEY `idx_chromguid` (`ChromGuid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_peaks
-- ----------------------------

-- ----------------------------
-- Table structure for tb_peakshape
-- ----------------------------
DROP TABLE IF EXISTS `tb_peakshape`;
CREATE TABLE `tb_peakshape` (
  `ChromGuid` char(36) NOT NULL,
  `ShapeGuid` char(36) NOT NULL,
  `ShapeType` int(11) NOT NULL COMMENT '		PS_None,\r\n		PS_Single,\r\n		PS_OverLap',
  `HorzType` int(11) NOT NULL DEFAULT '0' COMMENT 'enum HorzType\r\n{\r\n	OT_Null,\r\n	OT_HorzForward,\r\n	OT_HorzBackWard\r\n};'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_peakshape
-- ----------------------------

-- ----------------------------
-- Table structure for tb_peakshape_peaks
-- ----------------------------
DROP TABLE IF EXISTS `tb_peakshape_peaks`;
CREATE TABLE `tb_peakshape_peaks` (
  `ShapeGuid` char(36) NOT NULL,
  `RetainTime` double NOT NULL,
  `RidingType` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_peakshape_peaks
-- ----------------------------

-- ----------------------------
-- Table structure for tb_printtemplate
-- ----------------------------
DROP TABLE IF EXISTS `tb_printtemplate`;
CREATE TABLE `tb_printtemplate` (
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `TemplateType` int(11) NOT NULL COMMENT 'enum PrintTemplateType\r\n{\r\n	PTT_Single,\r\n	PTT_Mulity\r\n};',
  `Method` int(11) NOT NULL COMMENT 'enum PrintTemplateItemMethod\r\n{\r\n	PTIM_None		= 0,\r\n	PTIM_Name		= 1,\r\n	PTIM_Method		= 2,\r\n	PTIM_Column		= 4,\r\n	PTIM_Interal	= 8,\r\n	PTIM_Quantify	= 16\r\n};\r\n',
  `Chrom` int(11) NOT NULL COMMENT 'enum PrintTemplateItemChrom\r\n{\r\n	PTIC_None		= 0,\r\n	PTIC_File		= 1,\r\n	PTIC_Sample		= 2,\r\n};',
  `Result` int(11) NOT NULL,
  `Summary` int(11) NOT NULL,
  `SST` int(11) NOT NULL,
  `Calibrate` int(11) NOT NULL,
  `CreateTime` datetime NOT NULL,
  `LastModifyTime` datetime NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_printtemplate
-- ----------------------------

-- ----------------------------
-- Table structure for tb_printtemplatecorpinfo
-- ----------------------------
DROP TABLE IF EXISTS `tb_printtemplatecorpinfo`;
CREATE TABLE `tb_printtemplatecorpinfo` (
  `TemplateGuid` char(36) NOT NULL,
  `CorpInfo` varchar(255) CHARACTER SET gbk NOT NULL,
  `FaceName` varchar(255) CHARACTER SET gbk NOT NULL,
  `Height` int(11) NOT NULL,
  `Weight` int(11) NOT NULL,
  `ChartSet` int(11) NOT NULL,
  `Index` int(11) NOT NULL,
  `Type` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_printtemplatecorpinfo
-- ----------------------------

-- ----------------------------
-- Table structure for tb_printtemplateheader
-- ----------------------------
DROP TABLE IF EXISTS `tb_printtemplateheader`;
CREATE TABLE `tb_printtemplateheader` (
  `TemplateGuid` char(36) NOT NULL,
  `bPrint` int(11) NOT NULL,
  `bUseChromName` int(11) NOT NULL,
  `Text` varchar(255) CHARACTER SET gbk NOT NULL,
  `bCorp` int(11) NOT NULL,
  `bGrid` int(11) NOT NULL,
  `bPrintFooter` int(1) NOT NULL,
  `FooterMode` int(1) NOT NULL DEFAULT '0',
  `FooterText` varchar(255) CHARACTER SET gbk NOT NULL,
  `bTime` int(1) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_printtemplateheader
-- ----------------------------

-- ----------------------------
-- Table structure for tb_project
-- ----------------------------
DROP TABLE IF EXISTS `tb_project`;
CREATE TABLE `tb_project` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Guid` char(36) NOT NULL,
  `InstrumentGuid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `bDel` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`,`Guid`),
  UNIQUE KEY `Uni_ProjectGuid` (`Guid`)
) ENGINE=MyISAM AUTO_INCREMENT=94 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_project
-- ----------------------------

-- ----------------------------
-- Table structure for tb_projectmember
-- ----------------------------
DROP TABLE IF EXISTS `tb_projectmember`;
CREATE TABLE `tb_projectmember` (
  `ProjectGuid` char(36) NOT NULL,
  `UserGuid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  KEY `ProjectGuid_Member` (`ProjectGuid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_projectmember
-- ----------------------------

-- ----------------------------
-- Table structure for tb_projectnew
-- ----------------------------
DROP TABLE IF EXISTS `tb_projectnew`;
CREATE TABLE `tb_projectnew` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `bDel` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`,`Guid`),
  UNIQUE KEY `Uni_ProjectGuid` (`Guid`)
) ENGINE=MyISAM AUTO_INCREMENT=86 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_projectnew
-- ----------------------------

-- ----------------------------
-- Table structure for tb_projecttemplate
-- ----------------------------
DROP TABLE IF EXISTS `tb_projecttemplate`;
CREATE TABLE `tb_projecttemplate` (
  `ProjectGuid` char(36) NOT NULL,
  `ChromMedGuid` char(36) NOT NULL,
  `CalibrateGuid` char(36) NOT NULL,
  `PrintTemplateGuid` char(36) NOT NULL,
  `IntegralGuid` char(36) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_projecttemplate
-- ----------------------------

-- ----------------------------
-- Table structure for tb_projectusers
-- ----------------------------
DROP TABLE IF EXISTS `tb_projectusers`;
CREATE TABLE `tb_projectusers` (
  `porjectGuid` char(36) NOT NULL,
  `userGuid` char(36) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_projectusers
-- ----------------------------

-- ----------------------------
-- Table structure for tb_quantifymed
-- ----------------------------
DROP TABLE IF EXISTS `tb_quantifymed`;
CREATE TABLE `tb_quantifymed` (
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `ChromGuid` char(36) NOT NULL,
  `bDel` int(11) NOT NULL,
  PRIMARY KEY (`Guid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of tb_quantifymed
-- ----------------------------

-- ----------------------------
-- Table structure for tb_quantifymed_copy
-- ----------------------------
DROP TABLE IF EXISTS `tb_quantifymed_copy`;
CREATE TABLE `tb_quantifymed_copy` (
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `HalfPeakWidth` double NOT NULL,
  `Slope` double NOT NULL,
  `Drift` double NOT NULL,
  `TDBL` double NOT NULL,
  `ChromGuid` char(36) NOT NULL,
  `bDel` int(11) NOT NULL,
  PRIMARY KEY (`Guid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of tb_quantifymed_copy
-- ----------------------------

-- ----------------------------
-- Table structure for tb_quantifyparam
-- ----------------------------
DROP TABLE IF EXISTS `tb_quantifyparam`;
CREATE TABLE `tb_quantifyparam` (
  `QuantifyGuid` char(36) NOT NULL,
  `QualitativeType` int(11) NOT NULL COMMENT '	QLT_TimeWindow,\r\n	QLT_TimeBand',
  `WindowValue` double NOT NULL,
  `BandValue` double NOT NULL,
  `QuantifyType` int(11) NOT NULL COMMENT '定量方法类型：QMT_Normalization,//归一\r\nQMT_ESTD,	// 外标法\r\nQMT_ISTD,	// 内标法\r\nQMT_ASTD,	// 标准加入法',
  `ResponseBase` int(11) NOT NULL COMMENT '响应基础：RB_Area,	 RB_Height',
  `CarlibrateCount` int(11) NOT NULL COMMENT '校准点数',
  `CurveFitType` int(11) NOT NULL COMMENT '曲线拟合类型：0 线性',
  `Origin` int(11) NOT NULL COMMENT '原点：OP_Without, \r\nOP_Calc,\r\nOP_Pass',
  `WeightMethod` int(11) NOT NULL COMMENT '权重方法：0，无',
  `Unit` varchar(10) CHARACTER SET gbk NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_quantifyparam
-- ----------------------------

-- ----------------------------
-- Table structure for tb_quantifypeak
-- ----------------------------
DROP TABLE IF EXISTS `tb_quantifypeak`;
CREATE TABLE `tb_quantifypeak` (
  `QuantifyGuid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `RetainTime` double NOT NULL COMMENT '保留时间',
  `Area` double NOT NULL,
  `Height` double NOT NULL,
  `PeakGuid` char(36) NOT NULL,
  `Concents` varchar(300) NOT NULL,
  `TargetType` int(11) NOT NULL DEFAULT '0' COMMENT 'enum TargetType\r\n{\r\n	TT_Target,	// 目标峰\r\n	TT_ISTD,	// 内标峰\r\n	TT_Refer,	// 参考峰\r\n};',
  `ISTDGroupID` int(11) NOT NULL DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_quantifypeak
-- ----------------------------

-- ----------------------------
-- Table structure for tb_roleright
-- ----------------------------
DROP TABLE IF EXISTS `tb_roleright`;
CREATE TABLE `tb_roleright` (
  `RoleType` int(11) NOT NULL,
  `Module` int(11) NOT NULL,
  `Value` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_roleright
-- ----------------------------

-- ----------------------------
-- Table structure for tb_seq
-- ----------------------------
DROP TABLE IF EXISTS `tb_seq`;
CREATE TABLE `tb_seq` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Guid` char(36) NOT NULL,
  `ProjectGuid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `bDel` int(11) NOT NULL DEFAULT '0',
  `Mode` int(11) NOT NULL,
  `ShutDown` int(11) NOT NULL DEFAULT '0',
  `InstrumentGuid` char(36) NOT NULL,
  PRIMARY KEY (`ID`,`Guid`),
  UNIQUE KEY `Uni_SeqGuid` (`Guid`)
) ENGINE=MyISAM AUTO_INCREMENT=182 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_seq
-- ----------------------------

-- ----------------------------
-- Table structure for tb_seq_filter
-- ----------------------------
DROP TABLE IF EXISTS `tb_seq_filter`;
CREATE TABLE `tb_seq_filter` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `SeqGuid` char(36) NOT NULL,
  `FilterID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `SeqGuid` (`SeqGuid`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_seq_filter
-- ----------------------------

-- ----------------------------
-- Table structure for tb_serialconfig
-- ----------------------------
DROP TABLE IF EXISTS `tb_serialconfig`;
CREATE TABLE `tb_serialconfig` (
  `DeviceGuid` char(36) NOT NULL,
  `Com` int(11) NOT NULL,
  `Baud` int(11) NOT NULL,
  `Parity` int(11) NOT NULL COMMENT '0 = no parity, 1 = odd, 2 = event',
  `ByteSize` int(11) NOT NULL,
  `StopBits` int(11) NOT NULL COMMENT '0-1 stop bit, 1=1.5 stop bit, 2=2stop bits',
  `Pipe` int(11) NOT NULL DEFAULT '0' COMMENT '表示第几个串口'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_serialconfig
-- ----------------------------

-- ----------------------------
-- Table structure for tb_sst
-- ----------------------------
DROP TABLE IF EXISTS `tb_sst`;
CREATE TABLE `tb_sst` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `CreateTime` datetime NOT NULL,
  PRIMARY KEY (`ID`,`Guid`)
) ENGINE=MyISAM AUTO_INCREMENT=69 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_sst
-- ----------------------------

-- ----------------------------
-- Table structure for tb_sstchroms
-- ----------------------------
DROP TABLE IF EXISTS `tb_sstchroms`;
CREATE TABLE `tb_sstchroms` (
  `SSTGuid` char(36) NOT NULL,
  `ChromGuid` char(36) NOT NULL,
  `CalibrateGuid` char(36) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_sstchroms
-- ----------------------------

-- ----------------------------
-- Table structure for tb_sstresult
-- ----------------------------
DROP TABLE IF EXISTS `tb_sstresult`;
CREATE TABLE `tb_sstresult` (
  `SSTGuid` char(36) NOT NULL,
  `CompoundName` varchar(255) CHARACTER SET gbk NOT NULL,
  `ChromGuids` varchar(2000) NOT NULL,
  `AvgRetainTime` double NOT NULL,
  `RSDRetainTime` double NOT NULL,
  `AvgArea` double NOT NULL,
  `RSDArea` double NOT NULL,
  `AvgHeight` double NOT NULL,
  `RSDHeight` double NOT NULL,
  `AvgConcent` double NOT NULL,
  `RSDConcent` double NOT NULL,
  `IsCalc` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_sstresult
-- ----------------------------

-- ----------------------------
-- Table structure for tb_subdevice
-- ----------------------------
DROP TABLE IF EXISTS `tb_subdevice`;
CREATE TABLE `tb_subdevice` (
  `Guid` char(36) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `DeviceGuid` char(36) NOT NULL,
  `Type` int(11) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  PRIMARY KEY (`Guid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_subdevice
-- ----------------------------

-- ----------------------------
-- Table structure for tb_subdevicemed
-- ----------------------------
DROP TABLE IF EXISTS `tb_subdevicemed`;
CREATE TABLE `tb_subdevicemed` (
  `AnalyseGuid` char(36) NOT NULL,
  `VarName` varchar(255) DEFAULT NULL,
  `value` varchar(5000) DEFAULT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Type` int(11) NOT NULL COMMENT '数据类型：1，整数；2，浮点数；3，字符串',
  `ModuleDeviceGuid` char(36) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_subdevicemed
-- ----------------------------

-- ----------------------------
-- Table structure for tb_subdevicemeduserprog
-- ----------------------------
DROP TABLE IF EXISTS `tb_subdevicemeduserprog`;
CREATE TABLE `tb_subdevicemeduserprog` (
  `AnalyseGuid` char(36) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Module` varchar(255) NOT NULL,
  `VarName` varchar(255) DEFAULT NULL,
  `Value` varchar(255) DEFAULT NULL,
  `Index` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_subdevicemeduserprog
-- ----------------------------

-- ----------------------------
-- Table structure for tb_systemsetup
-- ----------------------------
DROP TABLE IF EXISTS `tb_systemsetup`;
CREATE TABLE `tb_systemsetup` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `SetupName` varchar(255) NOT NULL,
  `Value` varchar(1000) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_systemsetup
-- ----------------------------

-- ----------------------------
-- Table structure for tb_task
-- ----------------------------
DROP TABLE IF EXISTS `tb_task`;
CREATE TABLE `tb_task` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Guid` char(36) NOT NULL,
  `SeqGuid` char(36) NOT NULL,
  `bCheck` int(11) NOT NULL,
  `SampleID` varchar(255) CHARACTER SET gbk NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `LoopCount` int(11) NOT NULL,
  `InjectVol` int(11) NOT NULL,
  `InjectTime` int(11) NOT NULL,
  `VialNum` int(11) NOT NULL,
  `SampleType` int(11) NOT NULL COMMENT '0 未知样品；1 标准样品;2 空白样品',
  `MedGuid` char(36) DEFAULT NULL COMMENT '冗余方法信息',
  `MedName` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `ChromName` varchar(255) CHARACTER SET gbk NOT NULL,
  `ChromPath` varchar(255) CHARACTER SET gbk NOT NULL,
  `State` int(11) NOT NULL COMMENT 'ICTS_NULL, ICTS_Run, ICTS_Pause, ICTS_Stop, ICTS_Finish, ICTS_Exec',
  `CurIndex` int(11) NOT NULL DEFAULT '0',
  `bDel` int(11) NOT NULL DEFAULT '0',
  `SortIndex` int(11) NOT NULL,
  `Massic` double NOT NULL DEFAULT '1',
  `Dilute` double NOT NULL DEFAULT '1',
  `MateVol` double NOT NULL DEFAULT '1',
  `IntegralGuid` char(36) NOT NULL,
  `CalibrateGuid` char(36) NOT NULL,
  `PrintTemplateGuid` char(36) NOT NULL,
  PRIMARY KEY (`ID`,`Guid`),
  UNIQUE KEY `Uni_TaskGuid` (`Guid`)
) ENGINE=MyISAM AUTO_INCREMENT=857 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_task
-- ----------------------------

-- ----------------------------
-- Table structure for tb_taskmed
-- ----------------------------
DROP TABLE IF EXISTS `tb_taskmed`;
CREATE TABLE `tb_taskmed` (
  `AnalyseGuid` char(36) NOT NULL,
  `VarName` varchar(255) DEFAULT NULL,
  `value` varchar(5000) DEFAULT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Type` int(11) NOT NULL,
  `ModuleDeviceGuid` char(36) NOT NULL,
  `TaskGuid` char(36) NOT NULL,
  KEY `idx_taskguid` (`TaskGuid`,`AnalyseGuid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_taskmed
-- ----------------------------

-- ----------------------------
-- Table structure for tb_taskmedmain
-- ----------------------------
DROP TABLE IF EXISTS `tb_taskmedmain`;
CREATE TABLE `tb_taskmedmain` (
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `InstrumentGuid` char(36) NOT NULL,
  `TaskGuid` char(36) NOT NULL,
  `ColumnParam` varchar(255) CHARACTER SET gbk NOT NULL COMMENT '色谱柱参数',
  `MobilePhase` varchar(255) CHARACTER SET gbk NOT NULL COMMENT '流动相',
  KEY `idx_taskguid` (`TaskGuid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_taskmedmain
-- ----------------------------

-- ----------------------------
-- Table structure for tb_taskmeduserprog
-- ----------------------------
DROP TABLE IF EXISTS `tb_taskmeduserprog`;
CREATE TABLE `tb_taskmeduserprog` (
  `TaskGuid` char(36) NOT NULL,
  `AnalyseGuid` char(36) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Module` varchar(255) NOT NULL,
  `VarName` varchar(255) DEFAULT NULL,
  `Value` varchar(255) DEFAULT NULL,
  `Index` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_taskmeduserprog
-- ----------------------------

-- ----------------------------
-- Table structure for tb_task_export
-- ----------------------------
DROP TABLE IF EXISTS `tb_task_export`;
CREATE TABLE `tb_task_export` (
  `ID` int(11) NOT NULL DEFAULT '0',
  `Guid` char(36) NOT NULL,
  `SeqGuid` char(36) NOT NULL,
  `bCheck` int(11) NOT NULL,
  `SampleID` varchar(255) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `LoopCount` int(11) NOT NULL,
  `InjectVol` int(11) NOT NULL,
  `InjectTime` int(11) NOT NULL,
  `VialNum` int(11) NOT NULL,
  `SampleType` int(11) NOT NULL COMMENT '0 未知样品；1 标准样品;2 空白样品',
  `MedGuid` char(36) DEFAULT NULL COMMENT '冗余方法信息',
  `MedName` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `ChromName` varchar(255) NOT NULL,
  `ChromPath` varchar(255) CHARACTER SET gbk NOT NULL,
  `State` int(11) NOT NULL COMMENT 'ICTS_NULL, ICTS_Run, ICTS_Pause, ICTS_Stop, ICTS_Finish, ICTS_Exec',
  `CurIndex` int(11) NOT NULL DEFAULT '0',
  `bDel` int(11) NOT NULL DEFAULT '0',
  `SortIndex` int(11) NOT NULL,
  `Massic` double NOT NULL DEFAULT '1',
  `Dilute` double NOT NULL DEFAULT '1',
  `MateVol` double NOT NULL DEFAULT '1',
  `IntegralGuid` char(36) NOT NULL,
  `CalibrateGuid` char(36) NOT NULL,
  `PrintTemplateGuid` char(36) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_task_export
-- ----------------------------

-- ----------------------------
-- Table structure for tb_tcpconfig
-- ----------------------------
DROP TABLE IF EXISTS `tb_tcpconfig`;
CREATE TABLE `tb_tcpconfig` (
  `DeviceGuid` char(36) NOT NULL,
  `IP` varchar(255) NOT NULL,
  `Port` int(11) NOT NULL,
  `Pipe` int(11) NOT NULL DEFAULT '0' COMMENT '表示第几个串口'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_tcpconfig
-- ----------------------------

-- ----------------------------
-- Table structure for tb_user
-- ----------------------------
DROP TABLE IF EXISTS `tb_user`;
CREATE TABLE `tb_user` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `UserGuid` char(36) NOT NULL,
  `UserName` varchar(255) CHARACTER SET gbk NOT NULL,
  `Pwd` varchar(255) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `Tel` varchar(11) DEFAULT NULL,
  `Mail` varchar(255) DEFAULT NULL,
  `RoleType` int(11) NOT NULL,
  `LastLoginTime` datetime DEFAULT NULL,
  `IsDel` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_user
-- ----------------------------

-- ----------------------------
-- Table structure for tb_useroperate
-- ----------------------------
DROP TABLE IF EXISTS `tb_useroperate`;
CREATE TABLE `tb_useroperate` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `UserGuid` char(36) NOT NULL,
  `UserName` varchar(255) CHARACTER SET gbk NOT NULL,
  `ClassGuid` char(36) NOT NULL,
  `ClassName` varchar(255) CHARACTER SET gbk NOT NULL,
  `OperateModule` int(11) NOT NULL,
  `ModuleName` varchar(255) CHARACTER SET gbk NOT NULL,
  `OldValue` varchar(255) CHARACTER SET gbk NOT NULL,
  `NewValue` varchar(255) CHARACTER SET gbk NOT NULL,
  `Reason` varchar(255) CHARACTER SET gbk NOT NULL,
  `Content` varchar(255) CHARACTER SET gbk NOT NULL,
  `OpTime` datetime NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=6154 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tb_useroperate
-- ----------------------------

-- ----------------------------
-- Table structure for user_info
-- ----------------------------
DROP TABLE IF EXISTS `user_info`;
CREATE TABLE `user_info` (
  `guid` char(36) NOT NULL,
  `id` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `name` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `role` int(11) DEFAULT NULL,
  `flag` int(11) DEFAULT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of user_info
-- ----------------------------

-- ----------------------------
-- Table structure for user_info2
-- ----------------------------
DROP TABLE IF EXISTS `user_info2`;
CREATE TABLE `user_info2` (
  `guid` char(36) NOT NULL,
  `id` varchar(30) NOT NULL,
  `password` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(50) CHARACTER SET gbk NOT NULL DEFAULT '',
  `role` tinyint(4) NOT NULL DEFAULT '0',
  `flag` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`guid`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of user_info2
-- ----------------------------

-- ----------------------------
-- Table structure for user_role
-- ----------------------------
DROP TABLE IF EXISTS `user_role`;
CREATE TABLE `user_role` (
  `role` tinyint(4) NOT NULL DEFAULT '0',
  `module` tinyint(4) NOT NULL DEFAULT '0',
  `op_right` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`role`,`module`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of user_role
-- ----------------------------

-- ----------------------------
-- Procedure structure for addfield
-- ----------------------------
DROP PROCEDURE IF EXISTS `addfield`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `addfield`()
BEGIN


  	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_chrommedmain' AND column_name = 'InstrumentGuid') THEN
	alter table tb_chrommedmain add InstrumentGuid  char(36) NOT NULL AFTER Name; 
	END IF;


  	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_taskmedmain' AND column_name = 'InstrumentGuid') THEN
	alter table tb_taskmedmain add InstrumentGuid  char(36) NOT NULL AFTER Name; 
	END IF;


  	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_calibratecompoundinfoquantify' AND column_name = 'BEraseEmpty') THEN
	alter table tb_calibratecompoundinfoquantify add BEraseEmpty  int(1) default 0 NOT NULL; 
	END IF;


  	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_calibratecompoundinfo' AND column_name = 'k3') THEN
	alter table tb_calibratecompoundinfo add k3 double default 0 NOT NULL; 
	END IF;



  IF EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chromatogramext' AND column_name = 'RangeMax') THEN
  alter table tb_chromatogramext modify column RangeMax double; alter table tb_chromatogramext modify column RangeMin double;
  END IF;


	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_chromatogramext' AND column_name = 'CalcStd') THEN
	alter table tb_chromatogramext add CalcStd int(1) default 0 NOT NULL; 
	END IF;


	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_calibratechrompeakunknow' AND column_name = 'ForceName') THEN
	alter table tb_calibratechrompeakunknow add ForceName varchar(255) NOT NULL;
	alter table tb_calibratechrompeak add ForceName varchar(255) NOT NULL;
	alter table tb_peaks add ForceName varchar(255) NOT NULL;
	END IF;


	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_moduledevice' AND column_name = 'GroupID') THEN
	alter table tb_moduledevice add DevNo int(11) default 0 NOT NULL; 
	alter table tb_moduledevice add GroupID int(11) default 0 NOT NULL; 
	alter table tb_moduledevice add GroupName varchar(255) NOT NULL; 
	END IF;


	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_chromatogram' AND column_name = 'bDel') THEN
	alter table tb_chromatogram add bDel int(1) default 0 NOT NULL; 
	END IF;


	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_seq' AND column_name = 'InstrumentGuid') THEN
	alter table tb_seq add InstrumentGuid char(36) NOT NULL; 
    	update tb_seq q INNER JOIN tb_project p on q.ProjectGuid = p.Guid set q.InstrumentGuid = p.InstrumentGuid;
	UPDATE tb_seq set ProjectGuid = '11111111-1111-1111-1111-111111111111';
	END IF;


	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_task' AND column_name = 'Massic') THEN
	alter table tb_task add Massic double default 1 NOT NULL; 
	alter table tb_task add Dilute double default 1 NOT NULL;
	END IF;


	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_task' AND column_name = 'MateVol') THEN
	alter table tb_task add MateVol double default 1 NOT NULL; 
	alter table tb_chromatogram add MateVol double default 1 NOT NULL; 
	END IF;


	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_printtemplateheader' AND column_name = 'bPrintFooter') THEN
	alter table tb_printtemplateheader add bPrintFooter int(1) default 1 NOT NULL; 
	END IF;


	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_chromatogram' AND column_name = 'SampleID') THEN
	alter table tb_chromatogram add SampleID varchar(255) CHARACTER SET gbk NOT NULL; 
	END IF;


	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_printtemplateheader' AND column_name = 'FooterMode') THEN
	alter table tb_printtemplateheader add FooterMode int(1) default 0 NOT NULL; 
	alter table tb_printtemplateheader add FooterText varchar(255) CHARACTER SET gbk NOT NULL; 
	END IF;


	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_task' AND column_name = 'IntegralGuid') THEN
	alter table tb_task add IntegralGuid char(36) NOT NULL; 
	alter table tb_task add CalibrateGuid char(36) NOT NULL; 
	alter table tb_task add PrintTemplateGuid char(36) NOT NULL; 
	END IF;


  	IF NOT EXISTS (SELECT * FROM information_schema.columns 
    	WHERE table_schema = DATABASE()  AND table_name = 'tb_chromatogramext' AND column_name = 'RangeMaxX') THEN
  	alter table tb_chromatogramext Add column RangeMaxX double; 
	alter table tb_chromatogramext Add column RangeMinX double;
  	END IF;


  	IF NOT EXISTS (SELECT * FROM information_schema.columns 
    	WHERE table_schema = DATABASE()  AND table_name = 'tb_printtemplatecorpinfo' AND column_name = 'Type') THEN
  	alter table tb_printtemplatecorpinfo Add Type int(1) default 0 NOT NULL;  
  	END IF;


	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_printtemplateheader' AND column_name = 'bTime') THEN
	alter table tb_printtemplateheader add bTime int(1) NOT NULL;
	END IF;


	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_chromatogram' AND column_name = 'CheckCode') THEN
	alter table tb_chromatogram add CheckCode char(36) NOT NULL; 
	END IF;


	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_chromintegralnew' AND column_name = 'baselinechromguid') THEN
	alter table tb_chromintegralnew add baselinechromguid char(36) NOT NULL; 
	alter table tb_integralinfo add baselinechromguid char(36) NOT NULL; 
	END IF;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for addindex
-- ----------------------------
DROP PROCEDURE IF EXISTS `addindex`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `addindex`()
BEGIN


IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_taskmedmain' and index_name='idx_taskguid') THEN
    ALTER TABLE `tb_taskmedmain` ADD INDEX `idx_taskguid` USING BTREE (`TaskGuid`);

  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_taskmed' and index_name='idx_taskguid') THEN
    ALTER TABLE `tb_taskmed` ADD INDEX `idx_taskguid` USING BTREE (`TaskGuid`, `AnalyseGuid`);

  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chrommedmain' and index_name='idx_chromguid') THEN
    ALTER TABLE `tb_chrommedmain` ADD INDEX `idx_chromguid` USING BTREE (`ChromGuid`);

  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chrommed' and index_name='idx_chromguid') THEN
    ALTER TABLE `tb_chrommed` ADD INDEX `idx_chromguid` USING BTREE (`ChromGuid`, `AnalyseGuid`);
  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chromdatas' and index_name='idx_chromguid') THEN
    ALTER TABLE `tb_chromdatas` ADD INDEX `idx_chromguid` USING BTREE (`ChromGuid`);
  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chromdatasslopecurve' and index_name='idx_chromguid') THEN
    ALTER TABLE `tb_chromdatasslopecurve` ADD INDEX `idx_chromguid` USING BTREE (`ChromGuid`);
  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_peaks' and index_name='idx_chromguid') THEN
    ALTER TABLE `tb_peaks` ADD INDEX `idx_chromguid` USING BTREE (`ChromGuid`);
  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_peakfpoint' and index_name='idx_chromguid') THEN
    ALTER TABLE `tb_peakfpoint` ADD INDEX `idx_chromguid` USING BTREE (`ChromGuid`);
  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chromintegralop' and index_name='idx_chromguid') THEN
    ALTER TABLE `tb_chromintegralop` ADD INDEX `idx_chromguid` USING BTREE (`ChromGuid`);
  END IF;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for addtables
-- ----------------------------
DROP PROCEDURE IF EXISTS `addtables`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `addtables`()
BEGIN



    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chromatogramext') THEN
    CREATE TABLE `tb_chromatogramext` (
  `ChromGuid` char(36) NOT NULL,
  `RangeMax` double  NOT NULL,
  `RangeMin` double  NOT NULL,
  `CalcStd` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ChromGuid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

  END IF;


IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_moduledeviceproxy') THEN
    CREATE TABLE `tb_moduledeviceproxy` (
  `DeviceGuid` char(36) NOT NULL,
  `Name` varchar(255) NOT NULL,
  `Type` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

  END IF;


IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_devicesource') THEN
    CREATE TABLE `tb_devicesource` (
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Type` int(11) NOT NULL,
  `ConnType` int(11) NOT NULL DEFAULT '0' COMMENT '0, COM;1,TCP',
  `Count` int(11) NOT NULL,
  PRIMARY KEY (`Guid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

  END IF;


IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_devicesourceproxy') THEN
    CREATE TABLE `tb_devicesourceproxy` (
  `DeviceGuid` char(36) NOT NULL,
  `Name` varchar(255) NOT NULL,
  `Type` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

  END IF;


IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_deviceproxy') THEN
    CREATE TABLE `tb_deviceproxy` (
  `InstrumentGuid` char(36) NOT NULL,
  `SourceGuid` char(36) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `Proxy` int(11) NOT NULL DEFAULT '0' COMMENT '0, COM;1,TCP',
  PRIMARY KEY (`Guid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

  END IF;


IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_subdevicemeduserprog') THEN
    CREATE TABLE `tb_subdevicemeduserprog` (
  `AnalyseGuid` char(36) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Module` varchar(255) NOT NULL,
  `VarName` varchar(255) DEFAULT NULL,
  `Value` varchar(255) DEFAULT NULL,
  `Index` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

  END IF;


IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_taskmeduserprog') THEN
    CREATE TABLE `tb_taskmeduserprog` (
  `TaskGuid` char(36) NOT NULL,
  `AnalyseGuid` char(36) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Module` varchar(255) NOT NULL,
  `VarName` varchar(255) DEFAULT NULL,
  `Value` varchar(255) DEFAULT NULL,
  `Index` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

  END IF;


IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chrommeduserprog') THEN
    CREATE TABLE `tb_chrommeduserprog` (
  `ChromGuid` char(36) NOT NULL,
  `AnalyseGuid` char(36) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Module` varchar(255) NOT NULL,
  `VarName` varchar(255) DEFAULT NULL,
  `Value` varchar(255) DEFAULT NULL,
  `Index` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

  END IF;


IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_projectNew') THEN
    CREATE TABLE `tb_projectnew` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk COLLATE gbk_chinese_ci NOT NULL,
  `bDel` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`,`Guid`),
  UNIQUE KEY `Uni_ProjectGuid` (`Guid`)
) ENGINE=MyISAM AUTO_INCREMENT=86 DEFAULT CHARSET=latin1;
    INSERT INTO `tb_projectnew` VALUES ('1', '11111111-1111-1111-1111-111111111111', 'default', '0');

  END IF;


IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_tcpconfig') THEN
    CREATE TABLE `tb_tcpconfig` (
  `DeviceGuid` char(36) NOT NULL,
  `IP` varchar(255) NOT NULL,
  `Port` int(11) NOT NULL,
  `Pipe` int(11) NOT NULL DEFAULT '0' COMMENT '表示第几个串口'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

  END IF;


IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_projectusers') THEN
    CREATE TABLE `tb_projectusers` (
  `porjectGuid` char(36) NOT NULL,
  `userGuid` char(36) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
  END IF;


IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_systemsetup') THEN
    CREATE TABLE `tb_systemsetup` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SetupName` varchar(255) NOT NULL,
  `Value` varchar(1000) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
  END IF;


IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_instrument_filter') THEN
    CREATE TABLE `tb_instrument_filter` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `Name` varchar(64) CHARACTER SET gbk COLLATE gbk_chinese_ci NOT NULL,
  `InstrumentGuid` char(36) NOT NULL,
  `ProjectGuid` char(36) NOT NULL,
  `ParentID` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
  END IF;


IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_seq_filter') THEN
    CREATE TABLE `tb_seq_filter` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SeqGuid` char(36) NOT NULL,
  `FilterID` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `SeqGuid` (`SeqGuid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

insert into tb_instrument_filter (Name, InstrumentGuid, ProjectGuid, ParentID) select '2021', i.Guid, p.Guid, 0 from tb_projectNew p inner join tb_instrument i on i.bDel=0 where p.bDel = 0 and exists (select q.Guid from tb_seq q where p.Guid = q.ProjectGuid and q.bDel = 0 and q.InstrumentGuid = i.Guid);
insert into tb_seq_filter (SeqGuid, FilterID) select q.Guid, f.ID from tb_instrument_filter f inner join tb_instrument i on i.bDel = 0 inner join tb_projectNew p on p.bDel = 0 inner join tb_seq q on q.ProjectGuid = p.Guid and q.InstrumentGuid = i.Guid and q.bDel = 0 where f.InstrumentGuid = i.Guid and f.ProjectGuid = p.Guid;

  END IF;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for droptaskexport
-- ----------------------------
DROP PROCEDURE IF EXISTS `droptaskexport`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `droptaskexport`()
BEGIN
    DROP TABLE IF EXISTS `tb_export_task` ;
    DROP TABLE IF EXISTS `tb_export_seq`;
    DROP TABLE IF EXISTS `tb_export_chromatogram` ;
    DROP TABLE IF EXISTS `tb_export_chromatogramext` ;
    DROP TABLE IF EXISTS `tb_export_chromdatas` ;
    DROP TABLE IF EXISTS `tb_export_chromdatasslopecurve`;
    DROP TABLE IF EXISTS `tb_export_chromintegralnew` ;
	  DROP TABLE IF EXISTS `tb_export_chromintegralop` ;
		DROP TABLE IF EXISTS `tb_export_chrommedmain` ;
		DROP TABLE IF EXISTS `tb_export_chrommed` ;

	  DROP TABLE IF EXISTS `tb_export_peaks` ;
	  DROP TABLE IF EXISTS `tb_export_peakridings` ;
	  DROP TABLE IF EXISTS `tb_export_peakfpoint` ;
	  DROP TABLE IF EXISTS `tb_export_peakshape` ;
	  DROP TABLE IF EXISTS `tb_export_peakshape_peaks` ;

	  DROP TABLE IF EXISTS `tb_export_calibrate`;
	  DROP TABLE IF EXISTS `tb_export_calibratechrom` ;
    DROP TABLE IF EXISTS `tb_export_calibratechrompeak` ;
    DROP TABLE IF EXISTS `tb_export_calibratechrompeakunknow` ;
    DROP TABLE IF EXISTS `tb_export_calibratechromunknow` ;
    DROP TABLE IF EXISTS `tb_export_calibratecompoundinfo` ;
    DROP TABLE IF EXISTS `tb_export_calibratecompoundinfoquantify` ;
    DROP TABLE IF EXISTS `tb_export_useroperate` ;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for taskexport
-- ----------------------------
DROP PROCEDURE IF EXISTS `taskexport`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `taskexport`(in pr_v varchar(36))
BEGIN
    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_task') THEN
    CREATE TABLE `tb_export_task` as select * from tb_task where SeqGuid=pr_v; ELSE
    INSERT INTO `tb_export_task` select * from tb_task where SeqGuid=pr_v; 
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_seq') THEN
    CREATE TABLE `tb_export_seq` as select * from tb_seq where Guid=pr_v; ELSE
    INSERT INTO `tb_export_seq` select * from tb_seq where Guid=pr_v;
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chromatogram') THEN
    CREATE TABLE `tb_export_chromatogram` as select * from tb_chromatogram where SeqGuid = pr_v; ELSE
    INSERT INTO `tb_export_chromatogram` select * from tb_chromatogram where SeqGuid = pr_v;
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chromatogramext') THEN
    CREATE TABLE `tb_export_chromatogramext` as select * from tb_chromatogramext where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
    INSERT INTO `tb_export_chromatogramext` select * from tb_chromatogramext where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;
    
    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chromdatas') THEN
    CREATE TABLE `tb_export_chromdatas` as select * from tb_chromdatas where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
    INSERT INTO `tb_export_chromdatas` select * from tb_chromdatas where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;
        
    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chromdatasslopecurve') THEN
    CREATE TABLE `tb_export_chromdatasslopecurve` as select * from tb_chromdatasslopecurve where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
    INSERT INTO `tb_export_chromdatasslopecurve` select * from tb_chromdatasslopecurve where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chromintegralnew') THEN
    CREATE TABLE `tb_export_chromintegralnew` as select * from tb_chromintegralnew where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
    INSERT INTO `tb_export_chromintegralnew` select * from tb_chromintegralnew where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;
    
    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chromintegralop') THEN
	  CREATE TABLE `tb_export_chromintegralop` as select * from tb_chromintegralop where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
	  INSERT INTO `tb_export_chromintegralop` select * from tb_chromintegralop where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;
    
    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chrommedmain') THEN
		CREATE TABLE `tb_export_chrommedmain` as select * from tb_chrommedmain where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
		INSERT INTO `tb_export_chrommedmain` select * from tb_chrommedmain where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;
        
    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chrommed') THEN
		CREATE TABLE `tb_export_chrommed` as select * from tb_chrommed where AnalyseGuid in (select guid from tb_export_chrommedmain); ELSE
		INSERT INTO `tb_export_chrommed` select * from tb_chrommed where AnalyseGuid in (select guid from tb_export_chrommedmain);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_peaks') THEN
	  CREATE TABLE `tb_export_peaks` as select * from tb_peaks where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
	  INSERT INTO  `tb_export_peaks` select * from tb_peaks where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_peakridings') THEN
	  CREATE TABLE `tb_export_peakridings` as select * from tb_peakridings where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
	  INSERT INTO  `tb_export_peakridings` select * from tb_peakridings where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_peakfpoint') THEN
	  CREATE TABLE `tb_export_peakfpoint` as select * from tb_peakfpoint where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
	  INSERT INTO  `tb_export_peakfpoint` select * from tb_peakfpoint where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_peakshape') THEN
	  CREATE TABLE `tb_export_peakshape` as select * from tb_peakshape where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
	  INSERT INTO  `tb_export_peakshape` select * from tb_peakshape where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_peakshape_peaks') THEN
	  CREATE TABLE `tb_export_peakshape_peaks` as select * from tb_peakshape_peaks where shapeguid in (select shapeguid from tb_peakshape); ELSE
	  INSERT INTO  `tb_export_peakshape_peaks` select * from tb_peakshape_peaks where shapeguid in (select shapeguid from tb_peakshape);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_calibrate') THEN
	  CREATE TABLE `tb_export_calibrate` as select * from tb_calibrate where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
	  INSERT INTO  `tb_export_calibrate` select * from tb_calibrate where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_calibratechrom') THEN
	  CREATE TABLE `tb_export_calibratechrom` as select * from tb_calibratechrom where calibrateguid in (select guid from tb_calibrate); ELSE
	  INSERT INTO  `tb_export_calibratechrom` select * from tb_calibratechrom where calibrateguid in (select guid from tb_calibrate);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_calibratechrompeak') THEN
    CREATE TABLE `tb_export_calibratechrompeak` as select * from tb_calibratechrompeak where calibrateguid in (select guid from tb_calibrate); ELSE
    INSERT INTO  `tb_export_calibratechrompeak` select * from tb_calibratechrompeak where calibrateguid in (select guid from tb_calibrate);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_calibratechrompeakunknow') THEN
    CREATE TABLE `tb_export_calibratechrompeakunknow` as select * from tb_calibratechrompeakunknow where calibrateguid in (select guid from tb_calibrate); ELSE
    INSERT INTO  `tb_export_calibratechrompeakunknow` select * from tb_calibratechrompeakunknow where calibrateguid in (select guid from tb_calibrate);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_calibratechromunknow') THEN
    CREATE TABLE `tb_export_calibratechromunknow` as select * from tb_calibratechromunknow where calibrateguid in (select guid from tb_calibrate); ELSE
    INSERT INTO  `tb_export_calibratechromunknow` select * from tb_calibratechromunknow where calibrateguid in (select guid from tb_calibrate);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_calibratecompoundinfo') THEN
    CREATE TABLE `tb_export_calibratecompoundinfo` as select * from tb_calibratecompoundinfo where calibrateguid in (select guid from tb_calibrate); ELSE
    INSERT INTO  `tb_export_calibratecompoundinfo` select * from tb_calibratecompoundinfo where calibrateguid in (select guid from tb_calibrate);
    END IF;
        
    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_calibratecompoundinfoquantify') THEN
    CREATE TABLE `tb_export_calibratecompoundinfoquantify` as select * from tb_calibratecompoundinfoquantify where calibrateguid in (select guid from tb_calibrate); ELSE
    INSERT INTO  `tb_export_calibratecompoundinfoquantify` select * from tb_calibratecompoundinfoquantify where calibrateguid in (select guid from tb_calibrate);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_useroperate') THEN
     CREATE TABLE `tb_export_useroperate` as select * from tb_useroperate where ClassGuid = pr_v or 
EXISTS (select SeqGuid from tb_chromatogram where Guid=tb_useroperate.ClassGuid and pr_v =SeqGuid) 
or id in (select op.id  from tb_seq sq 
inner join tb_task tk on tk.SeqGuid = sq.guid and pr_v=sq.guid 
inner join tb_instrument mi on mi.Guid = sq.InstrumentGuid 
inner join tb_device d on d.InstrumentGuid = mi.Guid 
inner join tb_subdevice sd on sd.DeviceGuid = d.Guid 
inner join tb_useroperate op on op.ClassGuid = sd.Guid 
inner join( select a.ID as minid, b.ID as maxid, a.ClassGuid 
	from tb_useroperate a 
	join tb_useroperate b on a.ID < b.ID and a.ClassGuid = b.ClassGuid 
	WHERE a.OperateModule = 7 and a.Content like '%等待设备空闲'  and b.Content like '%当前针采集完成' and 
	NOT EXISTS(SELECT c.ID from tb_useroperate c WHERE c.ID > a.ID and c.ID < b.ID and (c.Content like '%等待设备空闲' or c.Content like '%当前针采集完成')) 
	order by a.ID) tmm on tmm.ClassGuid = tk.Guid and op.id BETWEEN minid and maxid); ELSE
    INSERT INTO  `tb_export_useroperate` select * from tb_useroperate where ClassGuid = pr_v or 
EXISTS (select SeqGuid from tb_chromatogram where Guid=tb_useroperate.ClassGuid and pr_v =SeqGuid) 
or id in (select op.id  from tb_seq sq 
inner join tb_task tk on tk.SeqGuid = sq.guid and pr_v=sq.guid 
inner join tb_instrument mi on mi.Guid = sq.InstrumentGuid 
inner join tb_device d on d.InstrumentGuid = mi.Guid 
inner join tb_subdevice sd on sd.DeviceGuid = d.Guid 
inner join tb_useroperate op on op.ClassGuid = sd.Guid 
inner join( select a.ID as minid, b.ID as maxid, a.ClassGuid 
	from tb_useroperate a 
	join tb_useroperate b on a.ID < b.ID and a.ClassGuid = b.ClassGuid 
	WHERE a.OperateModule = 7 and a.Content like '%等待设备空闲'  and b.Content like '%当前针采集完成' and 
	NOT EXISTS(SELECT c.ID from tb_useroperate c WHERE c.ID > a.ID and c.ID < b.ID and (c.Content like '%等待设备空闲' or c.Content like '%当前针采集完成')) 
	order by a.ID) tmm on tmm.ClassGuid = tk.Guid and op.id BETWEEN minid and maxid);
    END IF;


END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for updatefield
-- ----------------------------
DROP PROCEDURE IF EXISTS `updatefield`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `updatefield`()
BEGIN
ALTER TABLE tb_subdevicemed MODIFY COLUMN value varchar(5000);
ALTER TABLE tb_taskmed MODIFY COLUMN value varchar(5000);
ALTER TABLE tb_chrommed MODIFY COLUMN value varchar(5000);
ALTER TABLE tb_task MODIFY COLUMN SampleID varchar(255) CHARACTER SET gbk NOT NULL; 
ALTER TABLE tb_task MODIFY COLUMN ChromName varchar(255) CHARACTER SET gbk NOT NULL; 
alter table tb_calibratechrompeakunknow modify column YUnit varchar(255) CHARACTER SET gbk NOT NULL;
alter table tb_calibratechrompeakunknow modify column XUnit varchar(255) CHARACTER SET gbk NOT NULL;

update tb_moduledevice set name = 'SHA-12' where guid = '8C359A6E-6FEB-4FAA-8258-6183F0CA71C3';
update tb_moduledevice set name = 'SHA-12D' where guid = '1CCDF9D6-9D43-4D5C-B0C3-48CB451BFB94';
update tb_modulesubdevice set name = 'SHA-12' where guid = '7FF652E7-75FB-4C3B-84BB-10FF31C551C9';
update tb_modulesubdevice set name = 'SHA-12D' where guid = '1D3D2A96-26D0-4420-9DD1-375F37FCB202';

update tb_moduledeviceproxy set name = 'AS12D-A' where deviceguid = '1CCDF9D6-9D43-4D5C-B0C3-48CB451BFB94' and type = 1;
update tb_moduledeviceproxy set name = 'AS12D-B' where deviceguid = '1CCDF9D6-9D43-4D5C-B0C3-48CB451BFB94' and type=2 ;


	


END
;;
DELIMITER ;
