﻿DELIMITER ??

DROP PROCEDURE IF EXISTS taskexport??
CREATE PROCEDURE taskexport(in pr_v varchar(36))
BEGIN
    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_task') THEN
    CREATE TABLE `tb_export_task` as select * from tb_task where SeqGuid=pr_v; ELSE
    INSERT INTO `tb_export_task` select * from tb_task where SeqGuid=pr_v; 
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_seq') THEN
    CREATE TABLE `tb_export_seq` as select * from tb_seq where Guid=pr_v; ELSE
    INSERT INTO `tb_export_seq` select * from tb_seq where Guid=pr_v;
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chromatogram') THEN
    CREATE TABLE `tb_export_chromatogram` as select * from tb_chromatogram where SeqGuid = pr_v; ELSE
    INSERT INTO `tb_export_chromatogram` select * from tb_chromatogram where SeqGuid = pr_v;
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chromatogramext') THEN
    CREATE TABLE `tb_export_chromatogramext` as select * from tb_chromatogramext where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
    INSERT INTO `tb_export_chromatogramext` select * from tb_chromatogramext where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;
    
    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chromdatas') THEN
    CREATE TABLE `tb_export_chromdatas` as select * from tb_chromdatas where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
    INSERT INTO `tb_export_chromdatas` select * from tb_chromdatas where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;
        
    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chromdatasslopecurve') THEN
    CREATE TABLE `tb_export_chromdatasslopecurve` as select * from tb_chromdatasslopecurve where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
    INSERT INTO `tb_export_chromdatasslopecurve` select * from tb_chromdatasslopecurve where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chromintegralnew') THEN
    CREATE TABLE `tb_export_chromintegralnew` as select * from tb_chromintegralnew where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
    INSERT INTO `tb_export_chromintegralnew` select * from tb_chromintegralnew where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;
    
    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chromintegralop') THEN
	  CREATE TABLE `tb_export_chromintegralop` as select * from tb_chromintegralop where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
	  INSERT INTO `tb_export_chromintegralop` select * from tb_chromintegralop where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;
    
    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chrommedmain') THEN
		CREATE TABLE `tb_export_chrommedmain` as select * from tb_chrommedmain where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
		INSERT INTO `tb_export_chrommedmain` select * from tb_chrommedmain where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;
        
    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_chrommed') THEN
		CREATE TABLE `tb_export_chrommed` as select * from tb_chrommed where AnalyseGuid in (select guid from tb_export_chrommedmain); ELSE
		INSERT INTO `tb_export_chrommed` select * from tb_chrommed where AnalyseGuid in (select guid from tb_export_chrommedmain);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_peaks') THEN
	  CREATE TABLE `tb_export_peaks` as select * from tb_peaks where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
	  INSERT INTO  `tb_export_peaks` select * from tb_peaks where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_peakridings') THEN
	  CREATE TABLE `tb_export_peakridings` as select * from tb_peakridings where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
	  INSERT INTO  `tb_export_peakridings` select * from tb_peakridings where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_peakfpoint') THEN
	  CREATE TABLE `tb_export_peakfpoint` as select * from tb_peakfpoint where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
	  INSERT INTO  `tb_export_peakfpoint` select * from tb_peakfpoint where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_peakshape') THEN
	  CREATE TABLE `tb_export_peakshape` as select * from tb_peakshape where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
	  INSERT INTO  `tb_export_peakshape` select * from tb_peakshape where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_peakshape_peaks') THEN
	  CREATE TABLE `tb_export_peakshape_peaks` as select * from tb_peakshape_peaks where shapeguid in (select shapeguid from tb_peakshape); ELSE
	  INSERT INTO  `tb_export_peakshape_peaks` select * from tb_peakshape_peaks where shapeguid in (select shapeguid from tb_peakshape);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_calibrate') THEN
	  CREATE TABLE `tb_export_calibrate` as select * from tb_calibrate where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v); ELSE
	  INSERT INTO  `tb_export_calibrate` select * from tb_calibrate where chromguid in (select guid from tb_chromatogram where SeqGuid = pr_v);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_calibratechrom') THEN
	  CREATE TABLE `tb_export_calibratechrom` as select * from tb_calibratechrom where calibrateguid in (select guid from tb_calibrate); ELSE
	  INSERT INTO  `tb_export_calibratechrom` select * from tb_calibratechrom where calibrateguid in (select guid from tb_calibrate);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_calibratechrompeak') THEN
    CREATE TABLE `tb_export_calibratechrompeak` as select * from tb_calibratechrompeak where calibrateguid in (select guid from tb_calibrate); ELSE
    INSERT INTO  `tb_export_calibratechrompeak` select * from tb_calibratechrompeak where calibrateguid in (select guid from tb_calibrate);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_calibratechrompeakunknow') THEN
    CREATE TABLE `tb_export_calibratechrompeakunknow` as select * from tb_calibratechrompeakunknow where calibrateguid in (select guid from tb_calibrate); ELSE
    INSERT INTO  `tb_export_calibratechrompeakunknow` select * from tb_calibratechrompeakunknow where calibrateguid in (select guid from tb_calibrate);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_calibratechromunknow') THEN
    CREATE TABLE `tb_export_calibratechromunknow` as select * from tb_calibratechromunknow where calibrateguid in (select guid from tb_calibrate); ELSE
    INSERT INTO  `tb_export_calibratechromunknow` select * from tb_calibratechromunknow where calibrateguid in (select guid from tb_calibrate);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_calibratecompoundinfo') THEN
    CREATE TABLE `tb_export_calibratecompoundinfo` as select * from tb_calibratecompoundinfo where calibrateguid in (select guid from tb_calibrate); ELSE
    INSERT INTO  `tb_export_calibratecompoundinfo` select * from tb_calibratecompoundinfo where calibrateguid in (select guid from tb_calibrate);
    END IF;
        
    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_calibratecompoundinfoquantify') THEN
    CREATE TABLE `tb_export_calibratecompoundinfoquantify` as select * from tb_calibratecompoundinfoquantify where calibrateguid in (select guid from tb_calibrate); ELSE
    INSERT INTO  `tb_export_calibratecompoundinfoquantify` select * from tb_calibratecompoundinfoquantify where calibrateguid in (select guid from tb_calibrate);
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_useroperate') THEN
     CREATE TABLE `tb_export_useroperate` as select * from tb_useroperate where ClassGuid = pr_v or \
EXISTS (select SeqGuid from tb_chromatogram where Guid=tb_useroperate.ClassGuid and pr_v =SeqGuid) \
or id in (select op.id  from tb_seq sq \
inner join tb_task tk on tk.SeqGuid = sq.guid and pr_v=sq.guid \
inner join tb_instrument mi on mi.Guid = sq.InstrumentGuid \
inner join tb_device d on d.InstrumentGuid = mi.Guid \
inner join tb_subdevice sd on sd.DeviceGuid = d.Guid \
inner join tb_useroperate op on op.ClassGuid = sd.Guid \
inner join( select a.ID as minid, b.ID as maxid, a.ClassGuid \
	from tb_useroperate a \
	join tb_useroperate b on a.ID < b.ID and a.ClassGuid = b.ClassGuid \
	WHERE a.OperateModule = 7 and a.Content like '%等待设备空闲'  and b.Content like '%当前针采集完成' and \
	NOT EXISTS(SELECT c.ID from tb_useroperate c WHERE c.ID > a.ID and c.ID < b.ID and (c.Content like '%等待设备空闲' or c.Content like '%当前针采集完成')) \
	order by a.ID) tmm on tmm.ClassGuid = tk.Guid and op.id BETWEEN minid and maxid); ELSE
    INSERT INTO  `tb_export_useroperate` select * from tb_useroperate where ClassGuid = pr_v or \
EXISTS (select SeqGuid from tb_chromatogram where Guid=tb_useroperate.ClassGuid and pr_v =SeqGuid) \
or id in (select op.id  from tb_seq sq \
inner join tb_task tk on tk.SeqGuid = sq.guid and pr_v=sq.guid \
inner join tb_instrument mi on mi.Guid = sq.InstrumentGuid \
inner join tb_device d on d.InstrumentGuid = mi.Guid \
inner join tb_subdevice sd on sd.DeviceGuid = d.Guid \
inner join tb_useroperate op on op.ClassGuid = sd.Guid \
inner join( select a.ID as minid, b.ID as maxid, a.ClassGuid \
	from tb_useroperate a \
	join tb_useroperate b on a.ID < b.ID and a.ClassGuid = b.ClassGuid \
	WHERE a.OperateModule = 7 and a.Content like '%等待设备空闲'  and b.Content like '%当前针采集完成' and \
	NOT EXISTS(SELECT c.ID from tb_useroperate c WHERE c.ID > a.ID and c.ID < b.ID and (c.Content like '%等待设备空闲' or c.Content like '%当前针采集完成')) \
	order by a.ID) tmm on tmm.ClassGuid = tk.Guid and op.id BETWEEN minid and maxid);
    END IF;


END??


DROP PROCEDURE IF EXISTS droptaskexport??
CREATE PROCEDURE droptaskexport()
BEGIN
    DROP TABLE IF EXISTS `tb_export_task` ;
    DROP TABLE IF EXISTS `tb_export_seq`;
    DROP TABLE IF EXISTS `tb_export_chromatogram` ;
    DROP TABLE IF EXISTS `tb_export_chromatogramext` ;
    DROP TABLE IF EXISTS `tb_export_chromdatas` ;
    DROP TABLE IF EXISTS `tb_export_chromdatasslopecurve`;
    DROP TABLE IF EXISTS `tb_export_chromintegralnew` ;
	  DROP TABLE IF EXISTS `tb_export_chromintegralop` ;
		DROP TABLE IF EXISTS `tb_export_chrommedmain` ;
		DROP TABLE IF EXISTS `tb_export_chrommed` ;

	  DROP TABLE IF EXISTS `tb_export_peaks` ;
	  DROP TABLE IF EXISTS `tb_export_peakridings` ;
	  DROP TABLE IF EXISTS `tb_export_peakfpoint` ;
	  DROP TABLE IF EXISTS `tb_export_peakshape` ;
	  DROP TABLE IF EXISTS `tb_export_peakshape_peaks` ;

	  DROP TABLE IF EXISTS `tb_export_calibrate`;
	  DROP TABLE IF EXISTS `tb_export_calibratechrom` ;
    DROP TABLE IF EXISTS `tb_export_calibratechrompeak` ;
    DROP TABLE IF EXISTS `tb_export_calibratechrompeakunknow` ;
    DROP TABLE IF EXISTS `tb_export_calibratechromunknow` ;
    DROP TABLE IF EXISTS `tb_export_calibratecompoundinfo` ;
    DROP TABLE IF EXISTS `tb_export_calibratecompoundinfoquantify` ;
    DROP TABLE IF EXISTS `tb_export_useroperate` ;
END??

DELIMITER ;





