﻿DELIMITER ??
DROP PROCEDURE IF EXISTS addfield??
CREATE PROCEDURE addfield()
BEGIN

#1、tb_chrommedmain---InstrumentGuid（char，36, not null）
  	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_chrommedmain' AND column_name = 'InstrumentGuid') THEN
	alter table tb_chrommedmain add InstrumentGuid  char(36) NOT NULL AFTER Name; 
	END IF;

#2、tb_taskmedmain---InstrumentGuid（char，36, not null）
  	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_taskmedmain' AND column_name = 'InstrumentGuid') THEN
	alter table tb_taskmedmain add InstrumentGuid  char(36) NOT NULL AFTER Name; 
	END IF;

#3、tb_calibratecompoundinfoquantify---BEraseEmpty（int，1, not null）
  	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_calibratecompoundinfoquantify' AND column_name = 'BEraseEmpty') THEN
	alter table tb_calibratecompoundinfoquantify add BEraseEmpty  int(1) default 0 NOT NULL; 
	END IF;

#4、tb_calibratecompoundinfo---k3（double，0, not null）
  	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_calibratecompoundinfo' AND column_name = 'k3') THEN
	alter table tb_calibratecompoundinfo add k3 double default 0 NOT NULL; 
	END IF;


#5、tb_chromatogramext
  IF EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chromatogramext' AND column_name = 'RangeMax') THEN
  alter table tb_chromatogramext modify column RangeMax double; alter table tb_chromatogramext modify column RangeMin double;
  END IF;

#6、tb_chromatogramext---CalcStd（int，0, not null）
	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_chromatogramext' AND column_name = 'CalcStd') THEN
	alter table tb_chromatogramext add CalcStd int(1) default 0 NOT NULL; 
	END IF;

#7、tb_calibratechrompeakunknow---ForceName
	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_calibratechrompeakunknow' AND column_name = 'ForceName') THEN
	alter table tb_calibratechrompeakunknow add ForceName varchar(255) NOT NULL;
	alter table tb_calibratechrompeak add ForceName varchar(255) NOT NULL;
	alter table tb_peaks add ForceName varchar(255) NOT NULL;
	END IF;

#8、tb_moduledevice---GroupID（int，0, not null）groupName
	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_moduledevice' AND column_name = 'GroupID') THEN
	alter table tb_moduledevice add DevNo int(11) default 0 NOT NULL; 
	alter table tb_moduledevice add GroupID int(11) default 0 NOT NULL; 
	alter table tb_moduledevice add GroupName varchar(255) NOT NULL; 
	END IF;

#9、tb_chromatogram---bDel（int，0, not null）
	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_chromatogram' AND column_name = 'bDel') THEN
	alter table tb_chromatogram add bDel int(1) default 0 NOT NULL; 
	END IF;

#10、tb_seq---InstrumentGuid（char，36, not null）
	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_seq' AND column_name = 'InstrumentGuid') THEN
	alter table tb_seq add InstrumentGuid char(36) NOT NULL; 
    	update tb_seq q INNER JOIN tb_project p on q.ProjectGuid = p.Guid set q.InstrumentGuid = p.InstrumentGuid;
	UPDATE tb_seq set ProjectGuid = '11111111-1111-1111-1111-111111111111';
	END IF;

#11、tb_task---Massic（double，1, not null)
	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_task' AND column_name = 'Massic') THEN
	alter table tb_task add Massic double default 1 NOT NULL; 
	alter table tb_task add Dilute double default 1 NOT NULL;
	END IF;

#12、tb_task---MateVol（double，1, not null)
	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_task' AND column_name = 'MateVol') THEN
	alter table tb_task add MateVol double default 1 NOT NULL; 
	alter table tb_chromatogram add MateVol double default 1 NOT NULL; 
	END IF;

#13、tb_printtemplateheader---bPrintFooter（int，1, not null)
	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_printtemplateheader' AND column_name = 'bPrintFooter') THEN
	alter table tb_printtemplateheader add bPrintFooter int(1) default 1 NOT NULL; 
	END IF;

#14、tb_chromatogram---SampleID（varchar，255, not null）
	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_chromatogram' AND column_name = 'SampleID') THEN
	alter table tb_chromatogram add SampleID varchar(255) CHARACTER SET gbk NOT NULL; 
	END IF;

#15、tb_printtemplateheader---FooterMode（int，1, not null)
	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_printtemplateheader' AND column_name = 'FooterMode') THEN
	alter table tb_printtemplateheader add FooterMode int(1) default 0 NOT NULL; 
	alter table tb_printtemplateheader add FooterText varchar(255) CHARACTER SET gbk NOT NULL; 
	END IF;

#16、tb_task---（IntegralGuid)
	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_task' AND column_name = 'IntegralGuid') THEN
	alter table tb_task add IntegralGuid char(36) NOT NULL; 
	alter table tb_task add CalibrateGuid char(36) NOT NULL; 
	alter table tb_task add PrintTemplateGuid char(36) NOT NULL; 
	END IF;

#17、tb_chromatogramext
  	IF NOT EXISTS (SELECT * FROM information_schema.columns 
    	WHERE table_schema = DATABASE()  AND table_name = 'tb_chromatogramext' AND column_name = 'RangeMaxX') THEN
  	alter table tb_chromatogramext Add column RangeMaxX double; 
	alter table tb_chromatogramext Add column RangeMinX double;
  	END IF;

#17、tb_printtemplatecorpinfo
  	IF NOT EXISTS (SELECT * FROM information_schema.columns 
    	WHERE table_schema = DATABASE()  AND table_name = 'tb_printtemplatecorpinfo' AND column_name = 'Type') THEN
  	alter table tb_printtemplatecorpinfo Add Type int(1) default 0 NOT NULL;  
  	END IF;

#18、tb_printtemplateheader---bTime（int，1, not null)
	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_printtemplateheader' AND column_name = 'bTime') THEN
	alter table tb_printtemplateheader add bTime int(1) NOT NULL;
	END IF;

#19、tb_chromatogram---CheckCode（char，36, not null)
	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_chromatogram' AND column_name = 'CheckCode') THEN
	alter table tb_chromatogram add CheckCode char(36) NOT NULL; 
	END IF;

#20、tb_chromintegralnew---baselinechromguid（char，36, not null)
	IF NOT EXISTS (SELECT * FROM information_schema.columns 
  	WHERE table_schema = DATABASE()  AND table_name = 'tb_chromintegralnew' AND column_name = 'baselinechromguid') THEN
	alter table tb_chromintegralnew add baselinechromguid char(36) NOT NULL; 
	alter table tb_integralinfo add baselinechromguid char(36) NOT NULL; 
	END IF;

END??


DROP PROCEDURE IF EXISTS addtables??
CREATE PROCEDURE addtables()
BEGIN

#1、tb_chromatogramext

    IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chromatogramext') THEN
    CREATE TABLE `tb_chromatogramext` (
  `ChromGuid` char(36) NOT NULL,
  `RangeMax` double  NOT NULL,
  `RangeMin` double  NOT NULL,
  `CalcStd` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ChromGuid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

  END IF;

#2、tb_moduledeviceproxy
IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_moduledeviceproxy') THEN
    CREATE TABLE `tb_moduledeviceproxy` (
  `DeviceGuid` char(36) NOT NULL,
  `Name` varchar(255) NOT NULL,
  `Type` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

  END IF;

#3、tb_devicesource
IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_devicesource') THEN
    CREATE TABLE `tb_devicesource` (
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Type` int(11) NOT NULL,
  `ConnType` int(11) NOT NULL DEFAULT '0' COMMENT '0, COM;1,TCP',
  `Count` int(11) NOT NULL,
  PRIMARY KEY (`Guid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

  END IF;

#4、tb_devicesourceproxy
IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_devicesourceproxy') THEN
    CREATE TABLE `tb_devicesourceproxy` (
  `DeviceGuid` char(36) NOT NULL,
  `Name` varchar(255) NOT NULL,
  `Type` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

  END IF;

#5、tb_deviceproxy
IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_deviceproxy') THEN
    CREATE TABLE `tb_deviceproxy` (
  `InstrumentGuid` char(36) NOT NULL,
  `SourceGuid` char(36) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk NOT NULL,
  `Proxy` int(11) NOT NULL DEFAULT '0' COMMENT '0, COM;1,TCP',
  PRIMARY KEY (`Guid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

  END IF;

#6、tb_subdevicemeduserprog
IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_subdevicemeduserprog') THEN
    CREATE TABLE `tb_subdevicemeduserprog` (
  `AnalyseGuid` char(36) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Module` varchar(255) NOT NULL,
  `VarName` varchar(255) DEFAULT NULL,
  `Value` varchar(255) DEFAULT NULL,
  `Index` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

  END IF;

#7、tb_taskmeduserprog
IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_taskmeduserprog') THEN
    CREATE TABLE `tb_taskmeduserprog` (
  `TaskGuid` char(36) NOT NULL,
  `AnalyseGuid` char(36) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Module` varchar(255) NOT NULL,
  `VarName` varchar(255) DEFAULT NULL,
  `Value` varchar(255) DEFAULT NULL,
  `Index` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

  END IF;

#8、tb_chrommeduserprog
IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chrommeduserprog') THEN
    CREATE TABLE `tb_chrommeduserprog` (
  `ChromGuid` char(36) NOT NULL,
  `AnalyseGuid` char(36) NOT NULL,
  `ModuleGuid` char(36) NOT NULL,
  `Module` varchar(255) NOT NULL,
  `VarName` varchar(255) DEFAULT NULL,
  `Value` varchar(255) DEFAULT NULL,
  `Index` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

  END IF;

#9、tb_projectNew
IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_projectNew') THEN
    CREATE TABLE `tb_projectnew` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `Guid` char(36) NOT NULL,
  `Name` varchar(255) CHARACTER SET gbk COLLATE gbk_chinese_ci NOT NULL,
  `bDel` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`,`Guid`),
  UNIQUE KEY `Uni_ProjectGuid` (`Guid`)
) ENGINE=MyISAM AUTO_INCREMENT=86 DEFAULT CHARSET=latin1;
    INSERT INTO `tb_projectnew` VALUES ('1', '11111111-1111-1111-1111-111111111111', 'default', '0');

  END IF;

#10、tb_tcpconfig
IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_tcpconfig') THEN
    CREATE TABLE `tb_tcpconfig` (
  `DeviceGuid` char(36) NOT NULL,
  `IP` varchar(255) NOT NULL,
  `Port` int(11) NOT NULL,
  `Pipe` int(11) NOT NULL DEFAULT '0' COMMENT '表示第几个串口'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

  END IF;

#11、tb_projectusers
IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_projectusers') THEN
    CREATE TABLE `tb_projectusers` (
  `porjectGuid` char(36) NOT NULL,
  `userGuid` char(36) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
  END IF;

#11、tb_systemsetup
IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_systemsetup') THEN
    CREATE TABLE `tb_systemsetup` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SetupName` varchar(255) NOT NULL,
  `Value` varchar(1000) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
  END IF;

#12、tb_instrument_filter
IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_instrument_filter') THEN
    CREATE TABLE `tb_instrument_filter` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `Name` varchar(64) CHARACTER SET gbk COLLATE gbk_chinese_ci NOT NULL,
  `InstrumentGuid` char(36) NOT NULL,
  `ProjectGuid` char(36) NOT NULL,
  `ParentID` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
  END IF;

#13、tb_seq_filter
IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_seq_filter') THEN
    CREATE TABLE `tb_seq_filter` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SeqGuid` char(36) NOT NULL,
  `FilterID` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `SeqGuid` (`SeqGuid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

insert into tb_instrument_filter (Name, InstrumentGuid, ProjectGuid, ParentID) select '2021', i.Guid, p.Guid, 0 from tb_projectNew p inner join tb_instrument i on i.bDel=0 where p.bDel = 0 and exists (select q.Guid from tb_seq q where p.Guid = q.ProjectGuid and q.bDel = 0 and q.InstrumentGuid = i.Guid);
insert into tb_seq_filter (SeqGuid, FilterID) select q.Guid, f.ID from tb_instrument_filter f inner join tb_instrument i on i.bDel = 0 inner join tb_projectNew p on p.bDel = 0 inner join tb_seq q on q.ProjectGuid = p.Guid and q.InstrumentGuid = i.Guid and q.bDel = 0 where f.InstrumentGuid = i.Guid and f.ProjectGuid = p.Guid;

  END IF;

END??

DROP PROCEDURE IF EXISTS updatefield??
CREATE PROCEDURE updatefield()
BEGIN
ALTER TABLE tb_subdevicemed MODIFY COLUMN value varchar(5000);
ALTER TABLE tb_taskmed MODIFY COLUMN value varchar(5000);
ALTER TABLE tb_chrommed MODIFY COLUMN value varchar(5000);
ALTER TABLE tb_task MODIFY COLUMN SampleID varchar(255) CHARACTER SET gbk NOT NULL; 
ALTER TABLE tb_task MODIFY COLUMN ChromName varchar(255) CHARACTER SET gbk NOT NULL; 
alter table tb_calibratechrompeakunknow modify column YUnit varchar(255) CHARACTER SET gbk NOT NULL;
alter table tb_calibratechrompeakunknow modify column XUnit varchar(255) CHARACTER SET gbk NOT NULL;

update tb_moduledevice set name = 'SHA-12' where guid = '8C359A6E-6FEB-4FAA-8258-6183F0CA71C3';
update tb_moduledevice set name = 'SHA-12D' where guid = '1CCDF9D6-9D43-4D5C-B0C3-48CB451BFB94';
update tb_modulesubdevice set name = 'SHA-12' where guid = '7FF652E7-75FB-4C3B-84BB-10FF31C551C9';
update tb_modulesubdevice set name = 'SHA-12D' where guid = '1D3D2A96-26D0-4420-9DD1-375F37FCB202';

update tb_moduledeviceproxy set name = 'AS12D-A' where deviceguid = '1CCDF9D6-9D43-4D5C-B0C3-48CB451BFB94' and type = 1;
update tb_moduledeviceproxy set name = 'AS12D-B' where deviceguid = '1CCDF9D6-9D43-4D5C-B0C3-48CB451BFB94' and type=2 ;


	


END??

DROP PROCEDURE IF EXISTS taskexport??
CREATE PROCEDURE taskexport(in pr_v varchar(36))
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.columns 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_export_task') THEN
    CREATE TABLE `tb_export_task` as select * from tb_task where SeqGuid=pr_v;
    CREATE TABLE `tb_export_seq` as select * from tb_seq where Guid=pr_v;
	

  END IF;

END??


DROP PROCEDURE IF EXISTS addindex??
CREATE PROCEDURE addindex()
BEGIN


IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_taskmedmain' and index_name='idx_taskguid') THEN
    ALTER TABLE `tb_taskmedmain` ADD INDEX `idx_taskguid` USING BTREE (`TaskGuid`);

  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_taskmed' and index_name='idx_taskguid') THEN
    ALTER TABLE `tb_taskmed` ADD INDEX `idx_taskguid` USING BTREE (`TaskGuid`, `AnalyseGuid`);

  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chrommedmain' and index_name='idx_chromguid') THEN
    ALTER TABLE `tb_chrommedmain` ADD INDEX `idx_chromguid` USING BTREE (`ChromGuid`);

  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chrommed' and index_name='idx_chromguid') THEN
    ALTER TABLE `tb_chrommed` ADD INDEX `idx_chromguid` USING BTREE (`ChromGuid`, `AnalyseGuid`);
  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chromdatas' and index_name='idx_chromguid') THEN
    ALTER TABLE `tb_chromdatas` ADD INDEX `idx_chromguid` USING BTREE (`ChromGuid`);
  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chromdatasslopecurve' and index_name='idx_chromguid') THEN
    ALTER TABLE `tb_chromdatasslopecurve` ADD INDEX `idx_chromguid` USING BTREE (`ChromGuid`);
  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_peaks' and index_name='idx_chromguid') THEN
    ALTER TABLE `tb_peaks` ADD INDEX `idx_chromguid` USING BTREE (`ChromGuid`);
  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_peakfpoint' and index_name='idx_chromguid') THEN
    ALTER TABLE `tb_peakfpoint` ADD INDEX `idx_chromguid` USING BTREE (`ChromGuid`);
  END IF;

IF NOT EXISTS (SELECT * FROM information_schema.statistics 
    WHERE table_schema = DATABASE()  AND table_name = 'tb_chromintegralop' and index_name='idx_chromguid') THEN
    ALTER TABLE `tb_chromintegralop` ADD INDEX `idx_chromguid` USING BTREE (`ChromGuid`);
  END IF;

END??

CALL addtables()??
CALL addfield()??
CALL updatefield()??
CALL addindex()??
DELIMITER ;





